/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.stash.internal.scm.git.mesh.MeshConstants;
import com.atlassian.stash.internal.scm.git.mesh.MeshRouter;
import com.atlassian.stash.internal.scm.git.mesh.RouteHandle;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;

public class RoutePropagatingClientInterceptor
implements ClientInterceptor {
    private final MeshRouter router;

    public RoutePropagatingClientInterceptor(MeshRouter router) {
        this.router = router;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        ClientCall call = next.newCall(method, callOptions);
        final Integer partition = (Integer)callOptions.getOption(MeshConstants.OPT_PARTITION);
        final MeshNode node = (MeshNode)callOptions.getOption(MeshConstants.OPT_TARGET_NODE);
        if (partition == null || node == null) {
            return call;
        }
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(call){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                super.start(new RoutePropagatingCallListener(responseListener, partition, node), headers);
            }
        };
    }

    private class RoutePropagatingCallListener<RespT>
    extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT> {
        private final int partition;
        private final MeshNode node;

        public RoutePropagatingCallListener(ClientCall.Listener<RespT> delegate, int partition, MeshNode node) {
            super(delegate);
            this.partition = partition;
            this.node = node;
        }

        public void onClose(Status status, Metadata trailers) {
            try (RouteHandle ignored = RoutePropagatingClientInterceptor.this.router.assignPartition(this.partition, this.node);){
                super.onClose(status, trailers);
            }
        }

        public void onMessage(RespT message) {
            try (RouteHandle ignored = RoutePropagatingClientInterceptor.this.router.assignPartition(this.partition, this.node);){
                super.onMessage(message);
            }
        }

        public void onReady() {
            try (RouteHandle ignored = RoutePropagatingClientInterceptor.this.router.assignPartition(this.partition, this.node);){
                super.onReady();
            }
        }
    }
}

