/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.request.RequestLocal;
import com.atlassian.bitbucket.request.RequestManager;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcMetricsClientInterceptor
implements ClientInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RpcMetricsClientInterceptor.class);
    private final RequestLocal<RpcMetrics> requestLocal;

    public RpcMetricsClientInterceptor(int rpcCountThreshold, RequestManager requestManager) {
        this.requestLocal = requestManager.newRequestLocal(rpcMetrics -> rpcMetrics.log(rpcCountThreshold));
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        if (this.requestLocal.isActive()) {
            ((RpcMetrics)this.requestLocal.computeIfAbsent(RpcMetrics::new)).incrementRpcCallCount();
        }
        return next.newCall(method, callOptions);
    }

    static class RpcMetrics {
        private final AtomicInteger rpcCallCount = new AtomicInteger();

        RpcMetrics() {
        }

        public void incrementRpcCallCount() {
            this.rpcCallCount.incrementAndGet();
        }

        public void log(int rpcCountThreshold) {
            int count = this.rpcCallCount.get();
            if (count >= rpcCountThreshold) {
                log.debug("Completed with {} RPCs", (Object)count);
            }
        }
    }
}

