/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.commit.Changeset;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitListMergeFilter;
import com.atlassian.bitbucket.commit.CommitOrder;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.commit.SimpleChangeset;
import com.atlassian.bitbucket.commit.SimpleCommit;
import com.atlassian.bitbucket.commit.SimpleMinimalCommit;
import com.atlassian.bitbucket.commit.graph.CommitGraphNode;
import com.atlassian.bitbucket.commit.graph.SimpleCommitGraphNode;
import com.atlassian.bitbucket.content.Blame;
import com.atlassian.bitbucket.content.Change;
import com.atlassian.bitbucket.content.ContentTreeNode;
import com.atlassian.bitbucket.content.DiffWhitespace;
import com.atlassian.bitbucket.content.SimpleBlame;
import com.atlassian.bitbucket.content.SimpleChange;
import com.atlassian.bitbucket.dmz.mesh.ReplicaState;
import com.atlassian.bitbucket.dmz.mesh.RepositoryReplicaDetails;
import com.atlassian.bitbucket.mesh.rpc.util.ByteStringUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcAnnotatedTag;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBatchChangeType;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBlame;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBranch;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcChange;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcChangeType;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcChangeset;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCommit;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCreateWorkTreeRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDataStore;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDataStoreShard;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDiffColor;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDiffOptions;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDiffWhitespace;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitObjectInfo;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitObjectType;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcHookResult;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcHostingOperationType;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcHostingStreamResult;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcMergeConflict;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcMergeConflicts;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcMinimalCommit;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcNodeType;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPackCacheResult;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPerson;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcProposedRefUpdate;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPublicKey;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPullRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPullRequestRef;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPullRequestState;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRef;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRefUpdate;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcReplicaState;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRepositoryReplicaDetails;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRevListMerges;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRevListOrder;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcTag;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcThrottledResource;
import com.atlassian.bitbucket.mesh.util.KeyUtils;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.MinimalRefChange;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleBranch;
import com.atlassian.bitbucket.repository.SimpleMinimalRef;
import com.atlassian.bitbucket.repository.SimpleMinimalRefChange;
import com.atlassian.bitbucket.repository.SimpleRef;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.bitbucket.repository.SimpleTag;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.repository.Tag;
import com.atlassian.bitbucket.scm.AbstractDiffCommandParameters;
import com.atlassian.bitbucket.scm.AbstractDiffStatsSummaryCommandParameters;
import com.atlassian.bitbucket.scm.bulk.BulkChangeType;
import com.atlassian.bitbucket.scm.git.GitObjectType;
import com.atlassian.bitbucket.scm.git.GitRefPattern;
import com.atlassian.bitbucket.scm.git.command.diff.GitChangeType;
import com.atlassian.bitbucket.scm.git.command.merge.conflict.GitMergeConflict;
import com.atlassian.bitbucket.scm.git.protocol.GitScmRequestType;
import com.atlassian.bitbucket.scm.git.ref.GitAnnotatedTag;
import com.atlassian.bitbucket.scm.git.worktree.GitCheckoutType;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.user.SimplePerson;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.ShaUtils;
import com.atlassian.stash.internal.mesh.RemoteDataStore;
import com.atlassian.stash.internal.mesh.RemoteDataStoreShard;
import com.atlassian.stash.internal.scm.git.GitObjectInfo;
import com.atlassian.stash.internal.scm.git.hosting.HookResult;
import com.atlassian.stash.internal.scm.git.hosting.HostingResult;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.MergeConflictTranslator;
import com.atlassian.stash.internal.scm.git.ref.SimpleGitAnnotatedTag;
import com.atlassian.util.contentcache.CacheResult;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.PublicKey;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class RpcUtils {
    private static final String GIT_CHANGE_TYPE_PROP = "gitChangeType";

    private RpcUtils() {
        throw new UnsupportedOperationException("Instance creation is not supported");
    }

    @Nonnull
    public static RpcDiffOptions.Builder prepareDiffOptions(@Nonnull AbstractDiffCommandParameters parameters) {
        Objects.requireNonNull(parameters, "parameters");
        RpcDiffOptions.Builder builder = RpcDiffOptions.newBuilder().setColor(RpcDiffColor.COLOR_NEVER).setDstPrefix("dst://").setSrcPrefix("src://").setWhitespace(RpcUtils.toWhitespace(parameters.getWhitespace()));
        if (parameters.hasContextLines()) {
            builder.setContextLines(parameters.getContextLines());
        }
        return builder;
    }

    @Nonnull
    public static RpcDiffOptions.Builder prepareDiffOptions(@Nonnull AbstractDiffStatsSummaryCommandParameters parameters) {
        Objects.requireNonNull(parameters, "parameters");
        return RpcDiffOptions.newBuilder().setColor(RpcDiffColor.COLOR_NEVER).setWhitespace(RpcUtils.toWhitespace(parameters.getWhitespace()));
    }

    @Nonnull
    public static GitAnnotatedTag toAnnotatedTag(@Nonnull RpcAnnotatedTag annotatedTag) {
        RpcTag tag = Objects.requireNonNull(annotatedTag, "annotatedTag").getTag();
        String tagId = tag.getId().toStringUtf8();
        SimpleGitAnnotatedTag.Builder builder = (SimpleGitAnnotatedTag.Builder)((SimpleGitAnnotatedTag.Builder)((SimpleGitAnnotatedTag.Builder)((SimpleGitAnnotatedTag.Builder)new SimpleGitAnnotatedTag.Builder().message(annotatedTag.getMessage().toStringUtf8()).tagger(RpcUtils.toPerson(annotatedTag.getTagger())).id(tagId)).displayId(GitRefPattern.TAGS.unqualify(tagId))).hash(tag.getHash())).latestCommit(tag.getLatestCommit());
        if (annotatedTag.hasTaggerTimestamp()) {
            Timestamp taggerTimestamp = annotatedTag.getTaggerTimestamp();
            builder.taggerTimestamp(Instant.ofEpochSecond(taggerTimestamp.getSeconds(), taggerTimestamp.getNanos()));
        }
        return builder.build();
    }

    @Nonnull
    public static Blame toBlame(RpcBlame rpcBlame) {
        Objects.requireNonNull(rpcBlame, "rpcBlame");
        return new SimpleBlame.Builder().author(RpcUtils.toPerson(rpcBlame.getAuthor())).authorTimestamp(RpcUtils.toDate(rpcBlame.getAuthorTimestamp())).committer(RpcUtils.toPerson(rpcBlame.getCommitter())).committerTimestamp(RpcUtils.toDate(rpcBlame.getCommitterTimestamp())).commitId(rpcBlame.getCommitId().toStringUtf8()).fileName(rpcBlame.getFileName().toStringUtf8()).lineNumber(rpcBlame.getLineNumber()).spannedLines(rpcBlame.getSpannedLines()).build();
    }

    @Nonnull
    public static RpcBranch toBranch(@Nonnull Branch branch) {
        Objects.requireNonNull(branch, "branch");
        return RpcBranch.newBuilder().setId(ByteString.copyFromUtf8((String)branch.getId())).setDefault(branch.getIsDefault()).setLatestCommit(branch.getLatestCommit()).build();
    }

    @Nonnull
    public static Branch toBranch(@Nonnull RpcBranch branch) {
        String branchId = Objects.requireNonNull(branch, "branch").getId().toStringUtf8();
        return ((SimpleBranch.Builder)((SimpleBranch.Builder)((SimpleBranch.Builder)((SimpleBranch.Builder)new SimpleBranch.Builder().isDefault(branch.getDefault())).id(branchId)).displayId(GitRefPattern.HEADS.unqualify(branchId))).latestCommit(branch.getLatestCommit())).build();
    }

    @Nonnull
    public static BulkChangeType toBulkChangeType(RpcBatchChangeType changeType) {
        switch (changeType) {
            case BATCH_CHANGE_ADD: {
                return BulkChangeType.ADD;
            }
            case BATCH_CHANGE_DELETE: {
                return BulkChangeType.DELETE;
            }
            case BATCH_CHANGE_MODIFY: {
                return BulkChangeType.MODIFY;
            }
        }
        throw new IllegalArgumentException("Batch change type [" + String.valueOf(changeType) + "] is not a known BulkChangeType");
    }

    @Nullable
    public static CacheResult toCacheResult(RpcPackCacheResult cacheResult) {
        switch (cacheResult) {
            case PACK_CACHE_HIT: {
                return CacheResult.HIT;
            }
            case PACK_CACHE_MISS: {
                return CacheResult.MISS;
            }
            case PACK_CACHE_BYPASS: {
                return CacheResult.BYPASS;
            }
        }
        return null;
    }

    @Nonnull
    public static RpcCreateWorkTreeRequest.CheckoutType toCheckoutType(@Nullable GitCheckoutType checkoutType) {
        if (checkoutType == null) {
            return RpcCreateWorkTreeRequest.CheckoutType.NONE;
        }
        switch (checkoutType) {
            case NONE: {
                return RpcCreateWorkTreeRequest.CheckoutType.NONE;
            }
            case SPARSE: {
                return RpcCreateWorkTreeRequest.CheckoutType.SPARSE;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown checkout type: '%s' cannot proceed", checkoutType));
    }

    @Nonnull
    public static Change toChange(@Nonnull RpcChange change) {
        Objects.requireNonNull(change, "change");
        GitChangeType changeType = RpcUtils.toChangeType(change.getType());
        return ((SimpleChange.Builder)new SimpleChange.Builder().contentId(change.getContentId()).executable(change.hasExecutable() ? Boolean.valueOf(change.getExecutable()) : null).fromContentId(change.getFromContentId()).nodeType(RpcUtils.toNodeType(change.getNodeType())).path(change.getPath().toStringUtf8()).percentUnchanged(change.hasPercentUnchanged() ? change.getPercentUnchanged() : -1).property(GIT_CHANGE_TYPE_PROP, (Object)changeType)).srcExecutable(change.hasSrcExecutable() ? Boolean.valueOf(change.getSrcExecutable()) : null).srcPath(change.hasSrcPath() ? change.getSrcPath().toStringUtf8() : null).type(changeType.getType()).build();
    }

    @Nonnull
    public static Changeset toChangeset(@Nonnull RpcChangeset changeset, @Nonnull PageRequest changesPageRequest, @Nullable Repository repository) {
        Objects.requireNonNull(changeset, "change");
        Objects.requireNonNull(changesPageRequest, "changesPageRequest");
        List changes = (List)changeset.getChangesList().stream().map(RpcUtils::toChange).collect(MoreCollectors.toImmutableList());
        SimpleChangeset.Builder builder = new SimpleChangeset.Builder(RpcUtils.toCommit(changeset.getToCommit(), repository)).changes(PageUtils.createPage((Iterable)changes, (PageRequest)changesPageRequest));
        if (changeset.hasFromCommit()) {
            SimpleMinimalCommit fromCommit = new SimpleMinimalCommit.Builder(changeset.getFromCommit().getId()).build();
            builder.fromCommit((MinimalCommit)fromCommit);
        }
        return builder.build();
    }

    @Nonnull
    public static GitChangeType toChangeType(@Nonnull RpcChangeType changeType) {
        switch (Objects.requireNonNull(changeType, "changeType")) {
            case CHANGE_TYPE_ADD: {
                return GitChangeType.ADD;
            }
            case CHANGE_TYPE_COPY: {
                return GitChangeType.COPY;
            }
            case CHANGE_TYPE_DELETE: {
                return GitChangeType.DELETE;
            }
            case CHANGE_TYPE_MODIFY: {
                return GitChangeType.MODIFY;
            }
            case CHANGE_TYPE_RENAME: {
                return GitChangeType.RENAME;
            }
            case CHANGE_TYPE_TYPE: {
                return GitChangeType.TYPE;
            }
            case CHANGE_TYPE_UNMERGED: {
                return GitChangeType.UNMERGED;
            }
            case CHANGE_TYPE_UNKNOWN: {
                return GitChangeType.UNKNOWN;
            }
        }
        throw new IllegalArgumentException("Change type [" + String.valueOf(changeType) + "] is not a known ChangeType");
    }

    @Nonnull
    public static Commit toCommit(@Nonnull RpcCommit commit, @Nullable Repository repository) {
        Objects.requireNonNull(commit, "commit");
        return new SimpleCommit.Builder(commit.getId()).author(RpcUtils.toPerson(commit.getAuthor())).authorTimestamp(new Date(commit.getAuthorEpoch())).committer(RpcUtils.toPerson(commit.getCommitter())).committerTimestamp(new Date(commit.getCommitterEpoch())).message(commit.hasMessage() ? RpcUtils.chompAll(commit.getMessage().toStringUtf8()) : null).parents((Iterable)commit.getParentsList().stream().map(parent -> new SimpleMinimalCommit.Builder(parent).build()).collect(Collectors.toList())).repository(repository).build();
    }

    @Nonnull
    public static CommitGraphNode toCommitGraphNode(@Nonnull RpcMinimalCommit commit) {
        Objects.requireNonNull(commit, "commit");
        return new SimpleCommitGraphNode.Builder().commit((MinimalCommit)new SimpleMinimalCommit.Builder(commit.getId()).build()).parents((Iterable)commit.getParentsList().stream().map(id -> new SimpleMinimalCommit.Builder(id).build()).collect(Collectors.toList())).build();
    }

    @Nonnull
    public static HookResult toHookResult(@Nonnull RpcHookResult rpcHookResult) {
        switch (rpcHookResult) {
            case HOOK_RESULT_UNSPECIFIED: {
                return HookResult.UNSPECIFIED;
            }
            case HOOK_RESULT_ACCEPTED: {
                return new HookResult.Builder().accepted(true).called(true).build();
            }
            case HOOK_RESULT_REJECTED: {
                return new HookResult.Builder().accepted(false).called(true).build();
            }
            case HOOK_RESULT_NOT_CALLED: {
                return new HookResult.Builder().accepted(false).called(false).build();
            }
        }
        return HookResult.UNSPECIFIED;
    }

    @Nonnull
    public static HostingResult toHostingResult(RpcHostingStreamResult result) {
        return new HostingResult.Builder(RpcUtils.toScmRequestType(result.getOperationType())).cacheResult(RpcUtils.toCacheResult(result.getCacheResult())).filter(result.hasFilter() ? result.getFilter() : null).hookResult(RpcUtils.toHookResult(result.getHookResult())).protocolVersion(result.hasProtocolVersion() ? Integer.valueOf(result.getProtocolVersion()) : null).build();
    }

    @Nonnull
    public static List<GitMergeConflict> toMergeConflicts(@Nonnull RpcMergeConflicts conflicts) {
        ImmutableSet binaryPaths = ImmutableSet.copyOf((Collection)ByteStringUtils.toStringsLazily((List)conflicts.getBinaryPathsList()));
        return (List)conflicts.getConflictsList().stream().map(arg_0 -> RpcUtils.lambda$toMergeConflicts$2((Set)binaryPaths, conflicts, arg_0)).collect(MoreCollectors.toImmutableList());
    }

    @Nonnull
    public static MinimalRef toMinimalRef(@Nonnull String refId) {
        boolean tag = Objects.requireNonNull(refId, "refId").startsWith("refs/tags/");
        return ((SimpleMinimalRef.Builder)((SimpleMinimalRef.Builder)new SimpleMinimalRef.Builder().displayId(tag ? GitRefPattern.TAGS.unqualify(refId) : GitRefPattern.HEADS.unqualify(refId))).id(refId)).type((RefType)(tag ? StandardRefType.TAG : StandardRefType.BRANCH)).build();
    }

    @Nonnull
    public static MinimalRefChange toMinimalRefChange(@Nonnull RpcRefUpdate refUpdate) {
        Objects.requireNonNull(refUpdate, "refUpdate");
        String oldHash = refUpdate.getOldHash();
        String newHash = refUpdate.getNewHash();
        if (ShaUtils.hashesMatch((String)oldHash, (String)ShaUtils.NULL_SHA1) && ShaUtils.hashesMatch((String)newHash, (String)ShaUtils.NULL_SHA1)) {
            return ((SimpleMinimalRefChange.Builder)((SimpleMinimalRefChange.Builder)new SimpleMinimalRefChange.Builder().ref(RpcUtils.buildRef(refUpdate.getRefId().toStringUtf8()))).type(RefChangeType.DELETE)).build();
        }
        return RpcUtils.toRefChange(refUpdate);
    }

    @Nonnull
    public static ContentTreeNode.Type toNodeType(@Nonnull RpcNodeType nodeType) {
        switch (Objects.requireNonNull(nodeType, "nodeType")) {
            case NODE_DIRECTORY: {
                return ContentTreeNode.Type.DIRECTORY;
            }
            case NODE_FILE: {
                return ContentTreeNode.Type.FILE;
            }
            case NODE_SUBMODULE: {
                return ContentTreeNode.Type.SUBMODULE;
            }
        }
        throw new IllegalArgumentException("Node type [" + String.valueOf(nodeType) + "] is not a known ContentTreeNode.Type");
    }

    @Nonnull
    public static GitObjectInfo toObjectInfo(@Nonnull RpcGitObjectInfo info) {
        String objectId = Objects.requireNonNull(info, "info").getObjectId().toStringUtf8();
        return new GitObjectInfo.Builder(objectId, info.getSize(), RpcUtils.toObjectType(info.getType())).build();
    }

    @Nonnull
    public static GitObjectType toObjectType(@Nonnull RpcGitObjectType objectType) {
        switch (Objects.requireNonNull(objectType, "objectType")) {
            case OBJECT_BLOB: {
                return GitObjectType.BLOB;
            }
            case OBJECT_COMMIT: {
                return GitObjectType.COMMIT;
            }
            case OBJECT_TAG: {
                return GitObjectType.TAG;
            }
            case OBJECT_TREE: {
                return GitObjectType.TREE;
            }
        }
        throw new IllegalArgumentException("Object type [" + String.valueOf(objectType) + " is not a known GitObjectType");
    }

    @Nonnull
    public static RpcPerson toPerson(@Nonnull Person person) {
        Objects.requireNonNull(person, "person");
        return RpcPerson.newBuilder().setName(ByteString.copyFromUtf8((String)person.getName())).setEmail(StringUtils.defaultString((String)person.getEmailAddress())).buildPartial();
    }

    @Nonnull
    public static Person toPerson(@Nonnull RpcPerson person) {
        return new SimplePerson(Objects.requireNonNull(person, "person").getName().toStringUtf8(), person.getEmail());
    }

    @Nonnull
    public static RpcProposedRefUpdate toProposedRefUpdate(@Nonnull RefChange refChange) {
        Objects.requireNonNull(refChange, "refChange");
        RpcProposedRefUpdate.Builder builder = RpcProposedRefUpdate.newBuilder().setRefId(ByteString.copyFromUtf8((String)refChange.getRef().getId()));
        switch (refChange.getType()) {
            case ADD: {
                builder.setNewHash(refChange.getToHash()).setOldHash(ShaUtils.NULL_SHA1);
                break;
            }
            case DELETE: {
                builder.setNewHash(ShaUtils.NULL_SHA1).setOldHash(refChange.getFromHash());
                break;
            }
            case UPDATE: {
                builder.setNewHash(refChange.getToHash()).setOldHash(refChange.getFromHash());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported RefChange type " + String.valueOf(refChange.getType()));
            }
        }
        return builder.build();
    }

    @Nonnull
    public static PublicKey toPublicKey(@Nonnull RpcPublicKey publicKey) {
        Objects.requireNonNull(publicKey, "publicKey");
        return publicKey.hasDer() ? KeyUtils.parsePublicKeyFromDer((byte[])publicKey.getDer().toByteArray()) : KeyUtils.parsePublicKeyFromPkcs8((String)publicKey.getPkcs8());
    }

    @Nonnull
    public static RpcPublicKey toPublicKey(@Nonnull PublicKey publicKey) {
        Objects.requireNonNull(publicKey, "publicKey");
        return RpcPublicKey.newBuilder().setDer(ByteString.copyFrom((byte[])publicKey.getEncoded())).build();
    }

    @Nonnull
    public static RpcPullRequest toPullRequest(@Nonnull PullRequest pullRequest, @Nonnull GitRequestHelper requestHelper) {
        return RpcPullRequest.newBuilder().setFromRef(RpcUtils.toPullRequestRef(pullRequest.getFromRef(), requestHelper)).setId(pullRequest.getId()).setState(RpcUtils.toPullRequestState(pullRequest.getState())).setToRef(RpcUtils.toPullRequestRef(pullRequest.getToRef(), requestHelper)).setVersion(pullRequest.getVersion()).build();
    }

    @Nonnull
    public static RpcPullRequestRef toPullRequestRef(@Nonnull PullRequestRef ref, @Nonnull GitRequestHelper requestHelper) {
        return RpcPullRequestRef.newBuilder().setId(ByteString.copyFromUtf8((String)ref.getId())).setLatestCommit(ref.getLatestCommit()).setRepository(requestHelper.toRepositoryId(ref.getRepository())).build();
    }

    @Nonnull
    public static RpcPullRequestState toPullRequestState(@Nonnull PullRequestState state) {
        switch (Objects.requireNonNull(state, "state")) {
            case DECLINED: {
                return RpcPullRequestState.PR_STATE_DECLINED;
            }
            case MERGED: {
                return RpcPullRequestState.PR_STATE_MERGED;
            }
            case OPEN: {
                return RpcPullRequestState.PR_STATE_OPEN;
            }
        }
        throw new IllegalArgumentException("State [" + String.valueOf(state) + "] has no corresponding RpcPullRequestState");
    }

    @Nonnull
    public static SimpleRef toRef(@Nonnull RpcRef ref) {
        String id = Objects.requireNonNull(ref, "ref").getId().toStringUtf8();
        return ((SimpleRef.Builder)((SimpleRef.Builder)((SimpleRef.Builder)new SimpleRef.Builder().type((RefType)StandardRefType.BRANCH).id(id)).displayId(id)).latestCommit(ref.getObjectId())).build();
    }

    @Nonnull
    public static RefChange toRefChange(@Nonnull RpcRefUpdate refUpdate) {
        Objects.requireNonNull(refUpdate, "refUpdate");
        String oldHash = refUpdate.getOldHash();
        String newHash = refUpdate.getNewHash();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)oldHash), (Object)"RpcRefUpdate.old_hash must be provided");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)newHash), (Object)"RpcRefUpdate.new_hash must be provided");
        RefChangeType type = ShaUtils.hashesMatch((String)oldHash, (String)ShaUtils.NULL_SHA1) ? RefChangeType.ADD : (ShaUtils.hashesMatch((String)newHash, (String)ShaUtils.NULL_SHA1) ? RefChangeType.DELETE : RefChangeType.UPDATE);
        return ((SimpleRefChange.Builder)((SimpleRefChange.Builder)((SimpleRefChange.Builder)((SimpleRefChange.Builder)new SimpleRefChange.Builder().fromHash(oldHash)).toHash(newHash)).type(type)).ref(RpcUtils.buildRef(refUpdate.getRefId().toStringUtf8()))).build();
    }

    @Nonnull
    public static RpcRefUpdate toRefUpdate(@Nonnull RefChange refChange) {
        Objects.requireNonNull(refChange, "refChange");
        RpcRefUpdate.Builder updateBuilder = RpcRefUpdate.newBuilder().setRefId(ByteString.copyFromUtf8((String)refChange.getRef().getId()));
        switch (refChange.getType()) {
            case ADD: {
                updateBuilder.setNewHash(refChange.getToHash()).setOldHash(ShaUtils.NULL_SHA1);
                break;
            }
            case DELETE: {
                updateBuilder.setNewHash(ShaUtils.NULL_SHA1).setOldHash(refChange.getFromHash());
                break;
            }
            case UPDATE: {
                updateBuilder.setNewHash(refChange.getToHash()).setOldHash(refChange.getFromHash());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported RefChange type " + String.valueOf(refChange.getType()));
            }
        }
        return updateBuilder.build();
    }

    @Nonnull
    public static RemoteDataStore toRemoteDataStore(@Nonnull RpcDataStore dataStore) {
        Objects.requireNonNull(dataStore, "dataStore");
        RemoteDataStore.Type type = RpcUtils.toRemoteDataStoreType(dataStore.getType());
        return new RemoteDataStore.Builder(type).shards(Lists.transform((List)dataStore.getShardsList(), RpcUtils::toRemoteDataStoreShard)).build();
    }

    @Nonnull
    public static RemoteDataStoreShard toRemoteDataStoreShard(@Nonnull RpcDataStoreShard shard) {
        Objects.requireNonNull(shard, "shard");
        return new RemoteDataStoreShard.Builder(shard.getUsableSpace()).partitions(Lists.transform((List)shard.getPartitionsList(), hex -> Integer.parseInt(hex, 16))).build();
    }

    @Nonnull
    public static RemoteDataStore.Type toRemoteDataStoreType(@Nonnull RpcDataStore.Type type) {
        switch (Objects.requireNonNull(type, "type")) {
            case BITBUCKET: {
                return RemoteDataStore.Type.BITBUCKET;
            }
            case MANAGED: {
                return RemoteDataStore.Type.MANAGED;
            }
            case PATH: {
                return RemoteDataStore.Type.PATH;
            }
        }
        return RemoteDataStore.Type.UNKNOWN;
    }

    @Nonnull
    public static ReplicaState toReplicaState(@Nonnull RpcReplicaState state) {
        switch (Objects.requireNonNull(state, "state")) {
            case REPLICA_STATE_CONSISTENT: {
                return ReplicaState.CONSISTENT;
            }
            case REPLICA_STATE_MISSING: {
                return ReplicaState.MISSING;
            }
            case REPLICA_STATE_REPAIRING: {
                return ReplicaState.REPAIRING;
            }
            case REPLICA_STATE_INCONSISTENT: {
                return ReplicaState.INCONSISTENT;
            }
        }
        return ReplicaState.UNKNOWN;
    }

    @Nonnull
    public static RpcReplicaState toReplicaState(@Nonnull ReplicaState state) {
        switch (Objects.requireNonNull(state, "state")) {
            case CONSISTENT: {
                return RpcReplicaState.REPLICA_STATE_CONSISTENT;
            }
            case MISSING: {
                return RpcReplicaState.REPLICA_STATE_MISSING;
            }
            case REPAIRING: {
                return RpcReplicaState.REPLICA_STATE_REPAIRING;
            }
            case INCONSISTENT: {
                return RpcReplicaState.REPLICA_STATE_INCONSISTENT;
            }
        }
        return RpcReplicaState.REPLICA_STATE_UNKNOWN;
    }

    @Nonnull
    public static RepositoryReplicaDetails toRepositoryReplicaDetails(@Nonnull RpcRepositoryReplicaDetails details) {
        Objects.requireNonNull(details, "details");
        RepositoryReplicaDetails.Builder builder = new RepositoryReplicaDetails.Builder(RpcUtils.toReplicaState(details.getReplicaState())).observedVersion(details.getObservedVersion()).version(details.getVersion());
        if (details.hasContentHash()) {
            builder.contentHash(details.getContentHash());
        }
        if (details.hasMetadataHash()) {
            builder.metadataHash(details.getMetadataHash());
        }
        return builder.build();
    }

    @Nonnull
    public static RpcRevListMerges toRevListMerges(@Nonnull CommitListMergeFilter merges) {
        switch (Objects.requireNonNull(merges, "merges")) {
            case EXCLUDE: {
                return RpcRevListMerges.MERGES_EXCLUDE;
            }
            case ONLY: {
                return RpcRevListMerges.MERGES_ONLY;
            }
        }
        return RpcRevListMerges.MERGES_INCLUDE;
    }

    @Nonnull
    public static RpcRevListOrder toRevListOrder(@Nonnull CommitOrder commitOrder) {
        switch (Objects.requireNonNull(commitOrder, "commitOrder")) {
            case DEFAULT: {
                return RpcRevListOrder.ORDER_DEFAULT;
            }
            case TOPOLOGICAL: {
                return RpcRevListOrder.ORDER_TOPOLOGICAL;
            }
        }
        return RpcRevListOrder.ORDER_DATE;
    }

    @Nonnull
    public static GitScmRequestType toScmRequestType(@Nonnull RpcHostingOperationType operationType) {
        switch (Objects.requireNonNull(operationType, "operationType")) {
            case HOSTING_OP_ARCHIVE: {
                return GitScmRequestType.ARCHIVE;
            }
            case HOSTING_OP_CAPABILITIES: {
                return GitScmRequestType.CAPABILITIES;
            }
            case HOSTING_OP_CLONE: {
                return GitScmRequestType.CLONE;
            }
            case HOSTING_OP_FETCH: {
                return GitScmRequestType.FETCH;
            }
            case HOSTING_OP_NEGOTIATION: {
                return GitScmRequestType.NEGOTIATION;
            }
            case HOSTING_OP_PUSH: {
                return GitScmRequestType.PUSH;
            }
            case HOSTING_OP_REF_ADVERTISEMENT: {
                return GitScmRequestType.REFS;
            }
            case HOSTING_OP_SHALLOW_CLONE: {
                return GitScmRequestType.SHALLOW_CLONE;
            }
            case HOSTING_OP_SHALLOW_FETCH: {
                return GitScmRequestType.SHALLOW_FETCH;
            }
        }
        return GitScmRequestType.UNKNOWN;
    }

    @Nonnull
    public static Tag toTag(@Nonnull RpcTag tag) {
        String tagId = Objects.requireNonNull(tag, "tag").getId().toStringUtf8();
        return ((SimpleTag.Builder)((SimpleTag.Builder)((SimpleTag.Builder)new SimpleTag.Builder().id(tagId)).displayId(GitRefPattern.TAGS.unqualify(tagId))).hash(ByteStringUtils.emptyToNull((String)tag.getHash())).latestCommit(tag.getLatestCommit())).build();
    }

    @Nonnull
    public static String toThrottledResourceName(@Nonnull RpcThrottledResource resource) {
        switch (resource) {
            case RESOURCE_COMMAND: {
                return "scm-command";
            }
            case RESOURCE_MIRROR_PACK: {
                return "mirror-hosting";
            }
            case RESOURCE_PACK: {
                return "scm-hosting";
            }
            case RESOURCE_REFS: {
                return "scm-refs";
            }
        }
        return "unknown";
    }

    @Nonnull
    public static RpcDiffWhitespace toWhitespace(@Nonnull DiffWhitespace whitespace) {
        if (Objects.requireNonNull(whitespace, "whitespace") == DiffWhitespace.IGNORE_ALL) {
            return RpcDiffWhitespace.WHITESPACE_IGNORE_ALL;
        }
        return RpcDiffWhitespace.WHITESPACE_SHOW;
    }

    private static MinimalRef buildRef(String refId) {
        boolean isTag = refId.startsWith("refs/tags/");
        return ((SimpleMinimalRef.Builder)((SimpleMinimalRef.Builder)new SimpleMinimalRef.Builder().id(refId)).displayId(isTag ? GitRefPattern.TAGS.unqualify(refId) : GitRefPattern.HEADS.unqualify(refId))).type((RefType)(isTag ? StandardRefType.TAG : StandardRefType.BRANCH)).build();
    }

    private static String chompAll(String value) {
        int length;
        char last;
        int end;
        for (end = length = value.length(); end > 0 && ((last = value.charAt(end - 1)) == '\r' || last == '\n'); --end) {
        }
        return end == length ? value : value.substring(0, end);
    }

    private static Date toDate(Timestamp timestamp) {
        long millis = timestamp.getSeconds() * 1000L + (long)(timestamp.getNanos() / 1000000);
        return new Date(millis);
    }

    private static /* synthetic */ GitMergeConflict lambda$toMergeConflicts$2(Set binaryPaths, RpcMergeConflicts conflicts, RpcMergeConflict conflict) {
        return MergeConflictTranslator.parseConflict(conflict, binaryPaths, conflicts.getFromCommitId());
    }
}

