/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitError;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandFailedException;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import jakarta.annotation.Nonnull;
import java.util.Objects;

class SetTranscodeEnabledErrorTranslator
extends DefaultErrorTranslator {
    SetTranscodeEnabledErrorTranslator(@Nonnull I18nService i18nService, @Nonnull Repository repository) {
        super(i18nService, repository);
    }

    @Override
    protected ServiceException translate(RpcGitError error, Throwable cause) {
        switch (Objects.requireNonNull(error, "error").getErrorOneofCase()) {
            case ENABLE_TRANSCODE_FAILED: {
                return new CommandFailedException(this.i18nService.createKeyedMessage("bitbucket.git.transcode.enable.failed", new Object[0]), cause);
            }
            case DISABLE_TRANSCODE_FAILED: {
                return new CommandFailedException(this.i18nService.createKeyedMessage("bitbucket.git.transcode.disable.failed", new Object[0]), cause);
            }
        }
        return super.translate(error, cause);
    }
}

