/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.stash.internal.scm.PluginScmMXBean;
import com.atlassian.stash.internal.scm.git.mesh.SidecarHealthcheckStatistics;
import com.atlassian.stash.internal.scm.git.mesh.SidecarManager;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="sidecarMxBean")
public class SidecarMXBean
implements PluginScmMXBean {
    private final SidecarHealthcheckStatistics sidecarHealthcheck;

    public SidecarMXBean(SidecarManager sidecarManager) {
        this.sidecarHealthcheck = sidecarManager.getHealthcheckStatistics();
    }

    @Nonnull
    public Map<String, Object> getMxBeans() {
        return ImmutableMap.of((Object)"Healthcheck", (Object)new HealthcheckMXBean());
    }

    @Nonnull
    public String getNamespace() {
        return "sidecar";
    }

    public class HealthcheckMXBean
    implements SidecarHealthcheckStatistics {
        @Override
        public Duration getLastDurationUntilReady() {
            return SidecarMXBean.this.sidecarHealthcheck.getLastDurationUntilReady();
        }

        @Override
        public long getLastGrpcPingLatencyMs() {
            return SidecarMXBean.this.sidecarHealthcheck.getLastGrpcPingLatencyMs();
        }

        @Override
        public Instant getLastGrpcPingResponse() {
            return SidecarMXBean.this.sidecarHealthcheck.getLastGrpcPingResponse();
        }

        @Override
        public Instant getLastPingSent() {
            return SidecarMXBean.this.sidecarHealthcheck.getLastPingSent();
        }

        @Override
        public Instant getLastPongReceived() {
            return SidecarMXBean.this.sidecarHealthcheck.getLastPongReceived();
        }

        @Override
        public int getRestartCount() {
            return SidecarMXBean.this.sidecarHealthcheck.getRestartCount();
        }

        @Override
        public boolean isRunning() {
            return SidecarMXBean.this.sidecarHealthcheck.isRunning();
        }
    }
}

