/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.dmz.mesh.DmzMeshNodeRegistry;
import com.atlassian.bitbucket.mesh.MeshNode;
import jakarta.annotation.Nonnull;
import java.util.Date;

public class SidecarNode
implements MeshNode {
    private final boolean enabled;
    private final DmzMeshNodeRegistry nodeRegistry;
    private final String rpcUrl;

    SidecarNode(boolean enabled, int port, DmzMeshNodeRegistry nodeRegistry, boolean sslEnabled) {
        this.enabled = enabled;
        this.nodeRegistry = nodeRegistry;
        this.rpcUrl = (sslEnabled ? "https://" : "http://") + "localhost:" + port;
    }

    public String getAvailabilityZone() {
        return null;
    }

    public long getId() {
        return 0L;
    }

    public Date getLastSeenDate() {
        return this.nodeRegistry.getLastSeenDate((MeshNode)this);
    }

    @Nonnull
    public String getName() {
        return "Sidecar";
    }

    @Nonnull
    public String getRpcId() {
        return "sidecar";
    }

    @Nonnull
    public String getRpcUrl() {
        return this.rpcUrl;
    }

    @Nonnull
    public MeshNode.State getState() {
        return this.isOffline() ? MeshNode.State.OFFLINE : MeshNode.State.AVAILABLE;
    }

    public boolean isAvailable() {
        return this.nodeRegistry.isAvailable((MeshNode)this);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isOffline() {
        return !this.nodeRegistry.isAvailable((MeshNode)this);
    }

    public boolean isSidecar() {
        return true;
    }

    public String toString() {
        return this.getName() + "(" + this.rpcUrl + ")";
    }
}

