/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitError;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.signed.SigningFailedException;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigningErrorTranslator
extends DefaultErrorTranslator {
    private static final Logger log = LoggerFactory.getLogger(SigningErrorTranslator.class);

    SigningErrorTranslator(@Nonnull I18nService i18nService, @Nullable Repository repository) {
        super(i18nService, repository);
    }

    @Override
    protected ServiceException translate(RpcGitError error, Throwable cause) {
        if (error.hasSigningFailed()) {
            log.debug(cause.getMessage());
            switch (error.getSigningFailed().getReason()) {
                case INVALID_REQUEST: {
                    return new SigningFailedException(this.i18nService.createKeyedMessage("bitbucket.signing.error.invalid-request", new Object[0]));
                }
                case KEY_ISSUE: {
                    return new SigningFailedException(this.i18nService.createKeyedMessage("bitbucket.signing.error.key-issue", new Object[0]));
                }
                case CONFIGURATION_ISSUE: {
                    return new SigningFailedException(this.i18nService.createKeyedMessage("bitbucket.signing.error.configuration-issue", new Object[0]));
                }
                case SIGNING_FAILED: {
                    return new SigningFailedException(this.i18nService.createKeyedMessage("bitbucket.signing.error.signing-failed", new Object[0]));
                }
            }
        }
        return super.translate(error, cause);
    }
}

