/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.stash.internal.concurrent.TransferableState;
import com.atlassian.stash.internal.concurrent.TransferableStateManager;
import com.atlassian.stash.internal.scm.git.mesh.StatefulClientCallListener;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;

public class StateTransferringClientInterceptor
implements ClientInterceptor {
    private final TransferableStateManager stateManager;

    public StateTransferringClientInterceptor(TransferableStateManager stateManager) {
        this.stateManager = stateManager;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        final ClientCall delegate = next.newCall(method, callOptions);
        final TransferableState state = this.stateManager.getState();
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(this, delegate){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                delegate.start(new StatefulClientCallListener(responseListener, state), headers);
            }
        };
    }
}

