/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.stash.internal.concurrent.TransferableState;
import io.grpc.ClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.Status;

class StatefulClientCallListener<RespT>
extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT> {
    private final TransferableState state;

    StatefulClientCallListener(ClientCall.Listener<RespT> delegate, TransferableState state) {
        super(delegate);
        this.state = state;
    }

    public void onClose(Status status, Metadata trailers) {
        this.state.apply();
        try {
            super.onClose(status, trailers);
        }
        finally {
            this.state.remove();
        }
    }

    public void onMessage(RespT message) {
        this.state.apply();
        try {
            super.onMessage(message);
        }
        finally {
            this.state.remove();
        }
    }

    public void onReady() {
        this.state.apply();
        try {
            super.onReady();
        }
        finally {
            this.state.remove();
        }
    }
}

