/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetCommitsFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetCommitsIncludesExcludes;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetCommitsRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.scm.git.mesh.CommitsResponseObserver;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.protobuf.ByteString;
import io.grpc.stub.ClientCallStreamObserver;
import jakarta.annotation.Nonnull;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;

class StreamingGetCommitsObserver
extends CommitsResponseObserver<RpcGetCommitsFragment> {
    private final AtomicBoolean finishedSending;
    private final Iterator<RpcGetCommitsFragment> fragments;
    private final int maxFragmentSize;
    private final PeekingIterator<String> peekingExcludes;
    private final PeekingIterator<String> peekingIncludes;

    StreamingGetCommitsObserver(@Nonnull CommitCallback callback, @Nonnull I18nService i18nService, @Nonnull Repository repository, RpcGetCommitsRequest request, Iterator<String> includes, Iterator<String> excludes, int maxFragmentSize) {
        super(callback, i18nService, repository, request.getAlternatesCount() > 0);
        this.maxFragmentSize = maxFragmentSize;
        this.peekingExcludes = Iterators.peekingIterator(excludes);
        this.peekingIncludes = Iterators.peekingIterator(includes);
        this.finishedSending = new AtomicBoolean(false);
        this.fragments = Iterators.concat((Iterator)Iterators.singletonIterator((Object)RpcGetCommitsFragment.newBuilder().setRequest(request).build()), this.buildIncludesExcludesIterator());
    }

    @Override
    public void beforeStart(ClientCallStreamObserver<RpcGetCommitsFragment> requestStream) {
        super.beforeStart(requestStream);
        requestStream.setOnReadyHandler(() -> {
            while (requestStream.isReady() && this.fragments.hasNext()) {
                RpcGetCommitsFragment fragment = this.fragments.next();
                requestStream.onNext((Object)fragment);
            }
            if (!this.fragments.hasNext() && this.finishedSending.compareAndSet(false, true)) {
                requestStream.onCompleted();
            }
        });
    }

    private Iterator<RpcGetCommitsFragment> buildIncludesExcludesIterator() {
        return new Iterator<RpcGetCommitsFragment>(){

            @Override
            public boolean hasNext() {
                return StreamingGetCommitsObserver.this.peekingIncludes.hasNext() || StreamingGetCommitsObserver.this.peekingExcludes.hasNext();
            }

            @Override
            public RpcGetCommitsFragment next() {
                int size = 0;
                RpcGetCommitsIncludesExcludes.Builder builder = RpcGetCommitsIncludesExcludes.newBuilder();
                while (StreamingGetCommitsObserver.this.peekingIncludes.hasNext()) {
                    String include = (String)StreamingGetCommitsObserver.this.peekingIncludes.peek();
                    ByteString includeBytes = ByteString.copyFromUtf8((String)include);
                    if (size + includeBytes.size() > StreamingGetCommitsObserver.this.maxFragmentSize && size > 0) {
                        return RpcGetCommitsFragment.newBuilder().setIncludesExcludes(builder).build();
                    }
                    StreamingGetCommitsObserver.this.peekingIncludes.next();
                    builder.addIncludes(includeBytes);
                    size += includeBytes.size();
                }
                while (StreamingGetCommitsObserver.this.peekingExcludes.hasNext()) {
                    String exclude = (String)StreamingGetCommitsObserver.this.peekingExcludes.peek();
                    ByteString excludeBytes = ByteString.copyFromUtf8((String)exclude);
                    if (size + excludeBytes.size() > StreamingGetCommitsObserver.this.maxFragmentSize && size > 0) {
                        return RpcGetCommitsFragment.newBuilder().setIncludesExcludes(builder).build();
                    }
                    StreamingGetCommitsObserver.this.peekingExcludes.next();
                    builder.addExcludes(excludeBytes);
                    size += excludeBytes.size();
                }
                if (size == 0) {
                    throw new NoSuchElementException();
                }
                return RpcGetCommitsFragment.newBuilder().setIncludesExcludes(builder).build();
            }
        };
    }
}

