/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcTag;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcTagResponseFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcTagsRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.TagCallback;
import com.atlassian.bitbucket.repository.TagContext;
import com.atlassian.bitbucket.repository.TagSummary;
import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import io.grpc.Status;
import io.grpc.stub.ClientCallStreamObserver;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Objects;

class TagsResponseObserver
extends AbstractFutureResponseObserver<RpcTagsRequest, RpcTagResponseFragment, Void> {
    private final TagCallback callback;
    private final I18nService i18nService;
    private volatile ClientCallStreamObserver<RpcTagsRequest> requestStream;
    private volatile Throwable thrown;

    TagsResponseObserver(@Nonnull TagCallback callback, @Nonnull I18nService i18nService, @Nonnull Repository repository) {
        super(new DefaultErrorTranslator(i18nService, repository));
        this.callback = Objects.requireNonNull(callback, "callback");
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
    }

    @Override
    public void beforeStart(ClientCallStreamObserver<RpcTagsRequest> requestStream) {
        this.fireOnStart();
        this.requestStream = requestStream;
        super.beforeStart(this.requestStream);
    }

    @Override
    public void onCompleted() {
        Throwable t = this.fireOnEnd(this.thrown);
        if (t == null) {
            super.onCompleted();
        } else {
            super.onError(t);
        }
    }

    @Override
    public void onError(Throwable t) {
        Status status = Status.fromThrowable((Throwable)t);
        if (status.getCode() == Status.Code.CANCELLED && (t = status.getCause()) == null) {
            this.onCompleted();
            return;
        }
        super.onError(this.fireOnEnd(t));
    }

    public void onNext(RpcTagResponseFragment fragment) {
        try {
            for (RpcTag response : fragment.getResponsesList()) {
                if (this.callback.onTag(RpcUtils.toTag(response))) continue;
                this.requestStream.cancel("Canceled by callback", null);
                break;
            }
        }
        catch (IOException e) {
            this.thrown = this.wrapException(e);
            this.requestStream.onError(this.thrown);
        }
    }

    private Throwable fireOnEnd(Throwable thrown) {
        try {
            this.callback.onEnd(new TagSummary.Builder(thrown == null ? CommandResult.SUCCEEDED : CommandResult.FAILED).build());
        }
        catch (IOException e) {
            if (thrown == null) {
                thrown = this.wrapException(e);
            }
            thrown.addSuppressed(e);
        }
        return thrown;
    }

    private void fireOnStart() {
        try {
            this.callback.onStart(new TagContext.Builder().build());
        }
        catch (IOException e) {
            throw this.wrapException(this.fireOnEnd(e));
        }
    }

    private ServerException wrapException(Throwable cause) {
        return new ServerException(this.i18nService.createKeyedMessage("bitbucket.service.externalprocess.exception", new Object[]{cause.getMessage()}), cause);
    }
}

