/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.commit.graph.TraversalCallback;
import com.atlassian.bitbucket.commit.graph.TraversalContext;
import com.atlassian.bitbucket.commit.graph.TraversalStatus;
import com.atlassian.bitbucket.commit.graph.TraversalSummary;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcMinimalCommit;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcTraverseCommitsRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcTraverseCommitsResponseFragment;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import io.grpc.Status;
import io.grpc.stub.ClientCallStreamObserver;
import jakarta.annotation.Nonnull;

public class TraverseCommitsResponseObserver
extends AbstractFutureResponseObserver<RpcTraverseCommitsRequest, RpcTraverseCommitsResponseFragment, Void> {
    private final TraversalCallback callback;
    private final I18nService i18nService;
    private volatile boolean canceled;
    private volatile Throwable thrown;

    TraverseCommitsResponseObserver(@Nonnull TraversalCallback callback, @Nonnull I18nService i18nService, @Nonnull Repository repository) {
        super(new DefaultErrorTranslator(i18nService, repository));
        this.callback = callback;
        this.i18nService = i18nService;
    }

    @Override
    public void beforeStart(ClientCallStreamObserver<RpcTraverseCommitsRequest> requestStream) {
        this.fireOnStart();
        super.beforeStart(requestStream);
    }

    @Override
    public void onCompleted() {
        Throwable t = this.fireOnEnd(this.thrown);
        if (t == null) {
            super.onCompleted();
        } else {
            super.onError(t);
        }
    }

    @Override
    public void onError(Throwable t) {
        Status status = Status.fromThrowable((Throwable)t);
        if (status.getCode() == Status.Code.CANCELLED) {
            this.canceled = true;
            t = status.getCause();
            if (t == null) {
                this.onCompleted();
                return;
            }
        }
        super.onError(this.fireOnEnd(t));
    }

    public void onNext(RpcTraverseCommitsResponseFragment fragment) {
        if (this.canceled) {
            return;
        }
        for (RpcMinimalCommit commit : fragment.getCommitsList()) {
            try {
                if (this.callback.onNode(RpcUtils.toCommitGraphNode(commit)) != TraversalStatus.FINISH) continue;
                this.canceled = true;
                this.cancel("No more commits needed");
                return;
            }
            catch (RuntimeException e) {
                this.handleRuntimeException(e);
            }
        }
    }

    private Throwable fireOnEnd(Throwable thrown) {
        try {
            CommandResult result = this.canceled ? CommandResult.CANCELED : (thrown == null ? CommandResult.SUCCEEDED : CommandResult.FAILED);
            this.callback.onEnd(new TraversalSummary.Builder(result).build());
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
        return thrown;
    }

    private void fireOnStart() {
        try {
            this.callback.onStart(new TraversalContext.Builder().build());
        }
        catch (RuntimeException e) {
            throw this.wrapException(this.fireOnEnd(e));
        }
    }

    private void handleRuntimeException(RuntimeException e) {
        if (this.thrown == null) {
            this.thrown = e;
        } else {
            this.thrown.addSuppressed(e);
        }
    }

    private ServerException wrapException(Throwable cause) {
        return new ServerException(this.i18nService.createKeyedMessage("bitbucket.service.externalprocess.exception", new Object[]{cause.getMessage()}), cause);
    }
}

