/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class UploadPackFileParameters {
    private static final Duration DEFAULT_TIMEOUT = Duration.ofHours(4L);
    private final Iterable<String> excludes;
    private final Iterable<String> includes;
    private final Set<Repository> sources;
    private final Duration timeout;

    private UploadPackFileParameters(Builder builder) {
        this.sources = builder.sources.build();
        this.excludes = builder.excludes;
        this.includes = builder.includes;
        this.timeout = builder.timeout;
        Preconditions.checkState((!this.sources.isEmpty() ? 1 : 0) != 0, (Object)"At least one source repository must be specified");
    }

    @Nonnull
    public Iterable<String> getExcludes() {
        return this.excludes;
    }

    @Nonnull
    public Iterable<String> getIncludes() {
        return this.includes;
    }

    @Nonnull
    public Set<Repository> getSources() {
        return this.sources;
    }

    @Nonnull
    public Duration getTimeout() {
        return this.timeout;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<Repository> sources;
        private Iterable<String> excludes = Collections.emptySet();
        private Iterable<String> includes = Collections.emptySet();
        private Duration timeout;

        public Builder() {
            this.sources = ImmutableSet.builder();
            this.timeout = DEFAULT_TIMEOUT;
        }

        @Nonnull
        public UploadPackFileParameters build() {
            return new UploadPackFileParameters(this);
        }

        @Nonnull
        public Builder excludes(@Nonnull Iterable<String> values) {
            this.excludes = Builder.copyIfCollection(values);
            return this;
        }

        @Nonnull
        public Builder includes(@Nonnull Iterable<String> values) {
            this.includes = Builder.copyIfCollection(values);
            return this;
        }

        @Nonnull
        public Builder sources(@Nullable Repository value, Repository ... moreValues) {
            Builder.addIf(Objects::nonNull, this.sources, (Object)value, (Object[])moreValues);
            return this;
        }

        @Nonnull
        public Builder sources(@Nullable Iterable<Repository> values) {
            Builder.addIf(Objects::nonNull, this.sources, values);
            return this;
        }

        @Nonnull
        public Builder timeout(@Nonnull Duration value) {
            this.timeout = Objects.requireNonNull(value, "timeout");
            return this;
        }

        private static Iterable<String> copyIfCollection(@Nonnull Iterable<String> values) {
            if (values instanceof Collection) {
                return ImmutableSet.copyOf(values);
            }
            return values;
        }
    }
}

