/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.dmz.process.LineStdinHandler;
import com.atlassian.bitbucket.dmz.process.NioProcess;
import com.atlassian.bitbucket.dmz.process.NioStdoutHandler;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.util.ByteStringUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcStreamChunk;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcUploadPackFileFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcUploadPackFileRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcUploadPackFileResponse;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandInputHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.bitbucket.scm.git.command.packobjects.GitPackObjectsBuilder;
import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.BackoffClientCallStreamObserver;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.UploadPackFileParameters;
import com.atlassian.stash.internal.scm.git.mesh.UploadSummary;
import com.google.common.collect.Iterables;
import io.grpc.Status;
import io.grpc.stub.ClientCallStreamObserver;
import jakarta.annotation.Nonnull;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadPackFileResponseObserver
extends AbstractFutureResponseObserver<RpcUploadPackFileFragment, RpcUploadPackFileResponse, UploadSummary> {
    private static final Logger log = LoggerFactory.getLogger(UploadPackFileResponseObserver.class);
    private final GitCommandBuilderFactory builderFactory;
    private final UploadPackFileParameters parameters;
    private final Repository repository;
    private final RpcUploadPackFileRequest request;
    private PackObjectsOutputHandler handler;
    private volatile RuntimeException packObjectsException;

    UploadPackFileResponseObserver(GitCommandBuilderFactory builderFactory, I18nService i18nService, UploadPackFileParameters parameters, Repository repository, RpcUploadPackFileRequest request) {
        super(new DefaultErrorTranslator(i18nService, repository));
        this.builderFactory = builderFactory;
        this.parameters = parameters;
        this.repository = repository;
        this.request = request;
    }

    @Override
    public void beforeStart(ClientCallStreamObserver<RpcUploadPackFileFragment> requestStream) {
        super.beforeStart(new BackoffClientCallStreamObserver<RpcUploadPackFileFragment>(requestStream));
    }

    @Override
    public void onCompleted() {
        this.cancelPackObjectsIfRunning();
        super.onCompleted();
    }

    @Override
    public void onError(Throwable t) {
        Status status = Status.fromThrowable((Throwable)t);
        if (status.getCode() == Status.Code.CANCELLED && (t = status.getCause()) == null) {
            this.onCompleted();
            return;
        }
        this.cancelPackObjectsIfRunning();
        super.onError(this.packObjectsException == null ? t : this.packObjectsException);
    }

    public void onNext(RpcUploadPackFileResponse value) {
        this.setResult(this.handler.getOutput());
    }

    @Override
    UploadSummary asResult() {
        Set<Repository> sources = this.parameters.getSources();
        this.requestStream.onNext((Object)RpcUploadPackFileFragment.newBuilder().setRequest(this.request).build());
        Iterable stdin = Iterables.concat(this.parameters.getIncludes(), (Iterable)Iterables.transform(this.parameters.getExcludes(), exclude -> "^" + exclude));
        this.handler = new PackObjectsOutputHandler();
        Repository source = sources.iterator().next();
        GitCommand command = ((GitPackObjectsBuilder)this.builderFactory.builder(source).packObjects().alternates(sources)).deltaBaseOffset(true).inputHandler((CommandInputHandler)new LineStdinHandler(stdin)).revs(true).thin(true).build((CommandOutputHandler)this.handler);
        command.setTimeout(this.parameters.getTimeout());
        try {
            command.call();
            this.requestStream.onCompleted();
        }
        catch (RuntimeException e) {
            this.packObjectsException = e;
            this.requestStream.cancel("git pack-objects failed", (Throwable)e);
        }
        if (this.packObjectsException != null) {
            throw this.packObjectsException;
        }
        return (UploadSummary)super.asResult();
    }

    private void cancelPackObjectsIfRunning() {
        if (this.handler != null && this.handler.isRunning()) {
            this.handler.cancel();
        }
    }

    private class PackObjectsOutputHandler
    implements NioStdoutHandler<UploadSummary> {
        private final AtomicLong bytesSent = new AtomicLong();
        private volatile boolean canceled;
        private volatile NioProcess process;

        private PackObjectsOutputHandler() {
        }

        public void cancel() {
            this.canceled = true;
            if (this.process != null) {
                this.process.cancel();
            }
        }

        public UploadSummary getOutput() {
            return new UploadSummary(this.bytesSent.get(), 1);
        }

        public void onPreStart(@Nonnull NioProcess process) {
            this.process = process;
            if (this.canceled) {
                process.cancel();
            }
        }

        public void onStdout(@Nonnull ByteBuffer buffer, boolean closed) {
            int chunkSize = buffer.remaining();
            this.bytesSent.addAndGet(chunkSize);
            UploadPackFileResponseObserver.this.requestStream.onNext((Object)RpcUploadPackFileFragment.newBuilder().setChunk(RpcStreamChunk.newBuilder().setClosed(closed).setData(ByteStringUtils.unsafeWrap((ByteBuffer)buffer))).build());
            log.trace("[{}] UploadPackFile sent {} byte chunk ({} bytes sent so far)", new Object[]{UploadPackFileResponseObserver.this.repository, chunkSize, this.bytesSent.get()});
        }

        boolean isRunning() {
            return this.process != null && this.process.isRunning();
        }
    }
}

