/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitError;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitErrorUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcInvalidWorkTree;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcInvalidWorkTreePath;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.worktree.GitWorkTreeException;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import io.grpc.Metadata;
import io.grpc.Status;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.util.Objects;

public class WorkTreeErrorTranslator
extends DefaultErrorTranslator {
    WorkTreeErrorTranslator(@Nonnull I18nService i18nService, @Nullable Repository repository) {
        super(i18nService, repository);
    }

    @Override
    @Nonnull
    public Throwable maybeTranslate(@Nonnull Throwable cause) {
        RpcGitError gitError;
        if (cause instanceof ServiceException) {
            return cause;
        }
        Metadata metadata = Status.trailersFromThrowable((Throwable)Objects.requireNonNull(cause, "cause"));
        if (metadata != null && (gitError = RpcGitErrorUtils.fromMetadata((Metadata)metadata)) != null) {
            return this.translateMaybeWorkTree(gitError, cause);
        }
        return super.maybeTranslate(cause);
    }

    @Nonnull
    protected Exception translateMaybeWorkTree(@Nonnull RpcGitError error, @Nullable Throwable cause) {
        switch (Objects.requireNonNull(error, "error").getErrorOneofCase()) {
            case INVALID_WORK_TREE_PATH: {
                return this.translateInvalidPath(error.getInvalidWorkTreePath());
            }
            case NO_SUCH_WORK_TREE: {
                return new IllegalArgumentException("The work tree was not found, it may have expired or been deleted");
            }
            case INVALID_WORK_TREE: {
                return this.handleInvalidWorkTree(error.getInvalidWorkTree());
            }
            case WORK_TREE_WRITE_FAILED: {
                return new IOException(cause);
            }
        }
        return super.translate(error, cause);
    }

    private Exception handleInvalidWorkTree(RpcInvalidWorkTree invalidWorkTree) {
        switch (invalidWorkTree.getReason()) {
            case EXPIRED: {
                return new IllegalStateException("Work tree has expired");
            }
            case NO_COMMIT: {
                return new GitWorkTreeException(this.i18nService.createKeyedMessage("bitbucket.scm.git.worktree.commitunresolved", new Object[0]));
            }
        }
        return new IllegalStateException("[" + String.valueOf(invalidWorkTree.getReason()) + "] is not supported");
    }

    @Nonnull
    private Exception translateInvalidPath(RpcInvalidWorkTreePath invalidWorkTreePath) {
        switch (invalidWorkTreePath.getReason()) {
            case FILE_ALREADY_EXISTS: {
                return new FileAlreadyExistsException(invalidWorkTreePath.getPath().toStringUtf8());
            }
            case INVALID_LOCATION: 
            case INVALID_NAME: {
                return new IllegalArgumentException(invalidWorkTreePath.getPath().toStringUtf8() + " does not resolve to a path within the work tree");
            }
        }
        return new RuntimeException(invalidWorkTreePath.getPath().toStringUtf8() + "is invalid");
    }
}

