/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.mesh.rpc.util.ByteStringUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcStreamChunk;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcWriteWorkTreeFileFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcWriteWorkTreeFileRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcWriteWorkTreeFileResponse;
import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.ErrorTranslator;
import com.google.common.io.ByteStreams;
import io.grpc.Status;
import io.grpc.stub.ClientCallStreamObserver;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkTreeWriteFileResponseObserver
extends AbstractFutureResponseObserver<RpcWriteWorkTreeFileFragment, RpcWriteWorkTreeFileResponse, Void> {
    private static final Logger log = LoggerFactory.getLogger(WorkTreeWriteFileResponseObserver.class);
    private final InputStream content;
    private final RpcWriteWorkTreeFileRequest request;
    private final Object monitor;

    public WorkTreeWriteFileResponseObserver(@Nonnull RpcWriteWorkTreeFileRequest request, @Nonnull InputStream content, @Nonnull ErrorTranslator errorTranslator) {
        super(errorTranslator);
        this.request = Objects.requireNonNull(request, "request");
        this.content = Objects.requireNonNull(content, "content");
        this.monitor = new Object();
    }

    @Override
    public void beforeStart(ClientCallStreamObserver<RpcWriteWorkTreeFileFragment> requestStream) {
        super.beforeStart(requestStream);
        this.requestStream = requestStream;
        requestStream.setOnReadyHandler(() -> {
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notify();
            }
        });
    }

    @Override
    public void onError(Throwable t) {
        Throwable cause;
        Status status = Status.fromThrowable((Throwable)t);
        if (status.getCode() == Status.Code.CANCELLED && (cause = status.getCause()) != null) {
            t = cause;
        }
        super.onError(t);
    }

    public void onNext(RpcWriteWorkTreeFileResponse value) {
        this.setResult(null);
    }

    @Override
    <E extends Throwable> Void asResult(@Nullable Class<E> exceptionClass) throws E {
        this.requestStream.onNext((Object)RpcWriteWorkTreeFileFragment.newBuilder().setRequest(this.request).build());
        this.streamContent();
        return (Void)super.asResult(exceptionClass);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean requireReady() {
        if (this.requestStream.isReady()) {
            return true;
        }
        Object object = this.monitor;
        synchronized (object) {
            while (!this.isCanceled() && !this.isDone()) {
                if (this.requestStream.isReady()) {
                    return true;
                }
                try {
                    this.monitor.wait(3000L);
                }
                catch (InterruptedException e) {
                    if (this.isCanceled()) {
                        log.debug("Canceled while writing object content");
                        return false;
                    }
                    Thread.currentThread().interrupt();
                    throw Status.ABORTED.withCause((Throwable)e).withDescription("Interrupted while writing object content").asRuntimeException();
                }
            }
            return false;
        }
    }

    private void streamContent() {
        try {
            int read;
            byte[] buffer = new byte[65536];
            do {
                read = ByteStreams.read((InputStream)this.content, (byte[])buffer, (int)0, (int)buffer.length);
                if (!this.requireReady()) break;
                this.requestStream.onNext((Object)RpcWriteWorkTreeFileFragment.newBuilder().setContent(RpcStreamChunk.newBuilder().setClosed(read < buffer.length).setData(ByteStringUtils.unsafeWrap((byte[])buffer, (int)0, (int)read))).build());
            } while (read >= buffer.length);
            this.requestStream.onCompleted();
        }
        catch (IOException e) {
            this.requestStream.onError((Throwable)Status.ABORTED.withCause((Throwable)e).withDescription("Failed to copy object content").asRuntimeException());
        }
    }
}

