/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.mesh.rpc.ZeroCopyClientCallListener;
import com.atlassian.bitbucket.mesh.rpc.ZeroCopyMarshaller;
import com.atlassian.bitbucket.mesh.rpc.ZeroCopyUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcMarshallerType;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroCopyClientInterceptor
implements ClientInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ZeroCopyClientInterceptor.class);
    private final boolean enabled;
    private final ConcurrentMap<String, Optional<MethodDescriptor>> zeroCopyDescriptors;

    public ZeroCopyClientInterceptor(boolean enabled) {
        this.enabled = enabled;
        this.zeroCopyDescriptors = new ConcurrentHashMap<String, Optional<MethodDescriptor>>();
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        if (this.enabled) {
            return this.zeroCopyDescriptors.computeIfAbsent(method.getFullMethodName(), fqName -> ZeroCopyClientInterceptor.getZeroCopyMethod(method)).map(zeroCopyMethod -> zeroCopyMethod).map(zeroCopyMethod -> ZeroCopyClientInterceptor.interceptZeroCopy(zeroCopyMethod, callOptions, next)).orElseGet(() -> next.newCall(method, callOptions));
        }
        return next.newCall(method, callOptions);
    }

    private static <ReqT, RespT> ClientCall<ReqT, RespT> interceptZeroCopy(MethodDescriptor<ReqT, RespT> zeroCopyMethod, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(zeroCopyMethod, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                super.start((ClientCall.Listener)new ZeroCopyClientCallListener(responseListener), headers);
            }
        };
    }

    private static Optional<MethodDescriptor> getZeroCopyMethod(MethodDescriptor descriptor) {
        if (ZeroCopyUtils.getMarshallerType((MethodDescriptor)descriptor) == RpcMarshallerType.MARSHALLER_ZERO_COPY) {
            MethodDescriptor.Marshaller marshaller = descriptor.getResponseMarshaller();
            if (marshaller instanceof MethodDescriptor.PrototypeMarshaller) {
                return Optional.of(descriptor.toBuilder(descriptor.getRequestMarshaller(), (MethodDescriptor.Marshaller)new ZeroCopyMarshaller(() -> true, (MethodDescriptor.PrototypeMarshaller)marshaller)).build());
            }
            if (marshaller instanceof ZeroCopyMarshaller) {
                log.info("{} is already configured with a zero-copy marshaller", (Object)descriptor.getFullMethodName());
                return Optional.of(descriptor);
            }
            log.warn("Cannot configure a zero-copy marshaller for {}", (Object)descriptor.getFullMethodName());
        }
        return Optional.empty();
    }
}

