/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh.auth;

import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.rpc.MetadataKeys;
import com.atlassian.stash.internal.mesh.MeshKeyManager;
import com.atlassian.stash.internal.scm.git.mesh.MeshConstants;
import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.concurrent.Executor;

public class AuthenticationClientInterceptor
implements ClientInterceptor {
    private final CallCredentials credentials;

    public AuthenticationClientInterceptor(final MeshKeyManager keyManager, final boolean sidecarAuthenticationEnabled) {
        this.credentials = new CallCredentials(this){

            public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
                MeshNode target;
                if (!sidecarAuthenticationEnabled && (target = (MeshNode)requestInfo.getCallOptions().getOption(MeshConstants.OPT_TARGET_NODE)).isSidecar()) {
                    applier.apply(new Metadata());
                    return;
                }
                String token = keyManager.sign(requestInfo.getMethodDescriptor().getFullMethodName());
                Metadata metadata = new Metadata();
                metadata.put(MetadataKeys.KEY_TOKEN, (Object)token);
                applier.apply(metadata);
            }

            public void thisUsesUnstableApi() {
            }
        };
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return next.newCall(method, callOptions.withCallCredentials(this.credentials));
    }
}

