/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh.auth;

import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.util.KeyUtils;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.mesh.InternalMeshNode;
import com.atlassian.stash.internal.mesh.InternalMeshNodeKey;
import com.atlassian.stash.internal.mesh.InternalMeshSigningKey;
import com.atlassian.stash.internal.mesh.MeshNodeKeyDao;
import com.atlassian.stash.internal.mesh.MeshSigningKeyDao;
import com.atlassian.stash.internal.mesh.MeshSigningKeyOwner;
import com.atlassian.stash.internal.mesh.SigningKey;
import com.atlassian.stash.internal.scm.git.mesh.auth.MeshKeyRegistry;
import com.atlassian.stash.internal.scm.git.mesh.auth.SimpleSigningKey;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="meshKeyRegistry")
@Transactional(readOnly=true)
public class DatabaseMeshKeyRegistry
implements MeshKeyRegistry {
    private final MeshNodeKeyDao nodeKeyDao;
    private final MeshSigningKeyDao signingKeyDao;

    public DatabaseMeshKeyRegistry(MeshNodeKeyDao nodeKeyDao, MeshSigningKeyDao signingKeyDao) {
        this.nodeKeyDao = nodeKeyDao;
        this.signingKeyDao = signingKeyDao;
    }

    @Override
    @Nonnull
    public List<PublicKey> findByNode(@Nonnull MeshNode node) {
        Objects.requireNonNull(node, "node");
        List keys = this.nodeKeyDao.findByNode(node.getId());
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        return (List)keys.stream().map(key -> KeyUtils.parsePublicKeyFromDer((byte[])key.getDer())).collect(MoreCollectors.toImmutableList());
    }

    @Override
    public SigningKey findSigningKey(@Nonnull MeshSigningKeyOwner owner) {
        Objects.requireNonNull(owner, "owner");
        InternalMeshSigningKey key = this.signingKeyDao.findPrimaryByOwner(owner);
        if (key == null) {
            return null;
        }
        PublicKey publicKey = KeyUtils.parsePublicKeyFromDer((byte[])key.getPublicKeyDer());
        PrivateKey privateKey = KeyUtils.parsePrivateKeyFromDer((byte[])key.getPrivateKeyDer());
        return new SimpleSigningKey(key.getFingerprint(), publicKey, privateKey);
    }

    @Override
    @Nullable
    public PublicKey getByNodeIdAndFingerprint(long nodeId, @Nonnull String fingerprint) {
        Objects.requireNonNull(fingerprint, "fingerprint");
        InternalMeshNodeKey key = this.nodeKeyDao.getByNodeAndFingerprint(nodeId, fingerprint);
        if (key == null) {
            return null;
        }
        return KeyUtils.parsePublicKeyFromDer((byte[])key.getDer());
    }

    @Override
    @Transactional
    public boolean register(@Nonnull MeshNode node, @Nonnull PublicKey publicKey) {
        Objects.requireNonNull(node, "node");
        Objects.requireNonNull(publicKey, "publicKey");
        String fingerprint = KeyUtils.getFingerprint((PublicKey)publicKey);
        InternalMeshNodeKey key = (InternalMeshNodeKey)this.nodeKeyDao.getById((Object)new InternalMeshNodeKey.PK(fingerprint, node.getId()));
        if (key == null) {
            this.nodeKeyDao.create((Object)new InternalMeshNodeKey.Builder((InternalMeshNode)node, fingerprint).publicKey(publicKey).build());
            return true;
        }
        return false;
    }

    @Override
    @Transactional
    public boolean register(@Nonnull MeshSigningKeyOwner owner, @Nonnull SigningKey signingKey) {
        Objects.requireNonNull(owner, "owner");
        Objects.requireNonNull(signingKey, "signingKey");
        InternalMeshSigningKey key = (InternalMeshSigningKey)this.signingKeyDao.getById((Object)new InternalMeshSigningKey.PK(signingKey.getFingerprint(), owner));
        if (key == null) {
            this.signingKeyDao.create((Object)new InternalMeshSigningKey.Builder(owner, signingKey.getFingerprint()).privateKey(signingKey.getPrivate()).publicKey(signingKey.getPublic()).build());
            return true;
        }
        return false;
    }

    @Override
    @Transactional
    public boolean unregister(@Nonnull MeshNode node, @Nonnull PublicKey publicKey) {
        Objects.requireNonNull(node, "node");
        Objects.requireNonNull(publicKey, "publicKey");
        String fingerprint = KeyUtils.getFingerprint((PublicKey)publicKey);
        InternalMeshNodeKey key = (InternalMeshNodeKey)this.nodeKeyDao.getById((Object)new InternalMeshNodeKey.PK(fingerprint, node.getId()));
        if (key == null) {
            return false;
        }
        this.nodeKeyDao.delete((Object)key);
        return true;
    }

    @Override
    @Transactional
    public int unregisterAll(@Nonnull MeshNode node) {
        Objects.requireNonNull(node, "node");
        return this.nodeKeyDao.deleteByNode(node.getId());
    }
}

