/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh.auth;

import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.util.KeyUtils;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.stash.internal.mesh.MeshKeyManager;
import com.atlassian.stash.internal.mesh.MeshSigningKeyOwner;
import com.atlassian.stash.internal.mesh.SigningKey;
import com.atlassian.stash.internal.scm.git.mesh.auth.MeshKeyRegistry;
import com.atlassian.stash.internal.scm.git.mesh.auth.SimpleSigningKey;
import com.atlassian.stash.internal.utils.ClassLoaderUtils;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.Key;
import java.security.PublicKey;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMeshKeyManager
implements MeshKeyManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultMeshKeyManager.class);
    private final ClassLoader appClassLoader;
    private final MeshKeyRegistry keyRegistry;
    private final LockService lockService;
    private final CachedReference<SigningKey> signingKey;
    private final long tokenExpiryMs;

    public DefaultMeshKeyManager(ClassLoader appClassLoader, CacheFactory cacheFactory, MeshKeyRegistry keyRegistry, LockService lockService, Duration tokenExpiry) {
        this.appClassLoader = appClassLoader;
        this.keyRegistry = keyRegistry;
        this.lockService = lockService;
        this.signingKey = cacheFactory.getCachedReference("bb.mesh.control-plane.signing-key", () -> this.getOrGenerateSigningKey(MeshSigningKeyOwner.CONTROL_PLANE), new CacheSettingsBuilder().remote().replicateAsynchronously().replicateViaInvalidation().build());
        this.tokenExpiryMs = tokenExpiry.toMillis();
    }

    public boolean addKey(@Nonnull MeshNode node, @Nonnull PublicKey publicKey) {
        boolean added = this.keyRegistry.register(node, publicKey);
        if (added && log.isDebugEnabled()) {
            log.debug("{}: Added new public key: {}", (Object)node, (Object)KeyUtils.getFingerprint((PublicKey)publicKey));
        }
        return added;
    }

    @Nonnull
    public List<PublicKey> getKeysByNode(@Nonnull MeshNode node) {
        return this.keyRegistry.findByNode(node);
    }

    @Nullable
    public PublicKey getKeyByNodeIdAndFingerprint(long nodeId, @Nonnull String fingerprint) {
        Objects.requireNonNull(fingerprint, "fingerprint");
        return this.keyRegistry.getByNodeIdAndFingerprint(nodeId, fingerprint);
    }

    @Nonnull
    public SigningKey getSidecarKeys() {
        return this.getOrGenerateSigningKey(MeshSigningKeyOwner.SIDECAR);
    }

    @Nonnull
    public SigningKey getSigningKey() {
        return (SigningKey)this.signingKey.get();
    }

    @Nonnull
    public String sign(@Nonnull String subject) {
        Objects.requireNonNull(subject, "subject");
        return (String)ClassLoaderUtils.runWithClassloader((ClassLoader)this.appClassLoader, () -> {
            SigningKey signingKey = this.getSigningKey();
            Date now = new Date();
            return Jwts.builder().setExpiration(new Date(now.getTime() + this.tokenExpiryMs)).setHeaderParam("fp", (Object)signingKey.getFingerprint()).setHeaderParam("nid", (Object)"control-plane").setIssuedAt(now).setSubject(subject).signWith((Key)signingKey.getPrivate()).compact();
        });
    }

    private SigningKey getOrGenerateSigningKey(MeshSigningKeyOwner owner) {
        SigningKey signingKey = this.keyRegistry.findSigningKey(owner);
        if (signingKey == null) {
            try (LockGuard ignored = LockGuard.lock((Lock)this.lockService.getLock("mesh:signing-key:" + owner.getId()));){
                signingKey = this.keyRegistry.findSigningKey(owner);
                if (signingKey == null) {
                    signingKey = new SimpleSigningKey(Keys.keyPairFor((SignatureAlgorithm)SignatureAlgorithm.RS256));
                    this.keyRegistry.register(owner, signingKey);
                    log.info("{}: Generated new signing key: {}", (Object)owner, (Object)signingKey.getFingerprint());
                }
            }
        }
        return signingKey;
    }
}

