/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh.auth;

import com.atlassian.bitbucket.mesh.util.KeyUtils;
import com.atlassian.stash.internal.mesh.SigningKey;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Objects;

class SimpleSigningKey
implements SigningKey {
    private final String fingerprint;
    private final PrivateKey privateKey;
    private final PublicKey publicKey;

    SimpleSigningKey(@Nonnull KeyPair keyPair) {
        this(KeyUtils.getFingerprint((PublicKey)Objects.requireNonNull(keyPair, "keyPair").getPublic()), keyPair.getPublic(), keyPair.getPrivate());
    }

    SimpleSigningKey(@Nonnull String fingerprint, @Nonnull PublicKey publicKey, @Nonnull PrivateKey privateKey) {
        this.fingerprint = Objects.requireNonNull(fingerprint, "fingerprint");
        this.privateKey = Objects.requireNonNull(privateKey, "privateKey");
        this.publicKey = Objects.requireNonNull(publicKey, "publicKey");
    }

    @Nonnull
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Nonnull
    public PrivateKey getPrivate() {
        return this.privateKey;
    }

    @Nonnull
    public PublicKey getPublic() {
        return this.publicKey;
    }

    @Nonnull
    public KeyPair toKeyPair() {
        return new KeyPair(this.publicKey, this.privateKey);
    }

    public void writePublicKey(@Nonnull OutputStream outputStream) throws IOException {
        Objects.requireNonNull(outputStream, "outputStream");
        outputStream.write(KeyUtils.toPkcs8((PublicKey)this.publicKey).getBytes(StandardCharsets.US_ASCII));
    }
}

