/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh.worktree;

import com.atlassian.bitbucket.io.IoConsumer;
import com.atlassian.bitbucket.io.IoSupplier;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.io.MoreFiles;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCloseWorkTreeRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitTimeouts;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPublishWorkTreeRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcWorkTreeMkdirRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcWriteWorkTreeFileRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.command.GitWorkTreeCommandBuilder;
import com.atlassian.bitbucket.scm.git.worktree.GitWorkTree;
import com.atlassian.bitbucket.scm.git.worktree.PublishGitWorkTreeParameters;
import com.atlassian.stash.internal.scm.git.command.GitWorkTreeCommandBuilderFactory;
import com.atlassian.stash.internal.scm.git.mesh.RpcGitWorkTreeClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import jakarta.annotation.Nonnull;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import java.time.Instant;
import java.util.Objects;
import org.apache.commons.io.input.ReaderInputStream;

public class MeshGitWorkTree
implements GitWorkTree {
    private static final int BUFFER_SIZE = 65536;
    private final GitWorkTreeCommandBuilderFactory builderFactory;
    private final Clock clock;
    private final Instant expiry;
    private final boolean hasAlternates;
    private final Repository repository;
    private final MeshNode targetNode;
    private final Path tmpDir;
    private final RpcGitWorkTreeClient workTreeClient;
    private final String workTreeId;
    private boolean closed;

    public MeshGitWorkTree(GitWorkTreeCommandBuilderFactory builderFactory, Instant expiry, boolean hasAlternates, Repository repository, MeshNode targetNode, Path tmpDir, RpcGitWorkTreeClient workTreeClient, String workTreeId) {
        this(builderFactory, Clock.systemDefaultZone(), expiry, hasAlternates, repository, targetNode, tmpDir, workTreeClient, workTreeId);
        this.closed = false;
    }

    public MeshGitWorkTree(GitWorkTreeCommandBuilderFactory builderFactory, Clock clock, Instant expiry, boolean hasAlternates, Repository repository, MeshNode targetNode, Path tmpDir, RpcGitWorkTreeClient workTreeClient, String workTreeId) {
        this.builderFactory = builderFactory;
        this.clock = clock;
        this.expiry = expiry;
        this.hasAlternates = hasAlternates;
        this.repository = repository;
        this.targetNode = targetNode;
        this.tmpDir = tmpDir;
        this.workTreeClient = workTreeClient;
        this.workTreeId = workTreeId;
    }

    @Nonnull
    public GitWorkTreeCommandBuilder builder() {
        this.checkNotExpiredOrClosed();
        return this.builderFactory.builder(this);
    }

    public void close() {
        if (!this.closed) {
            RpcCloseWorkTreeRequest.Builder requestBuilder = RpcCloseWorkTreeRequest.newBuilder();
            this.workTreeClient.close(this, requestBuilder);
            this.closed = true;
        }
    }

    @Nonnull
    public Instant getExpiry() {
        return this.expiry;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public MeshNode getTargetNode() {
        return this.targetNode;
    }

    @Nonnull
    public String getWorkTreeId() {
        return this.workTreeId;
    }

    public boolean hasAlternates() {
        return this.hasAlternates;
    }

    public boolean isExpired() {
        return !this.clock.instant().isBefore(this.expiry);
    }

    public void mkdir(@Nonnull String relativePath) throws IOException {
        Objects.requireNonNull(relativePath, "relativePath");
        this.checkNotExpiredOrClosed();
        RpcWorkTreeMkdirRequest.Builder requestBuilder = RpcWorkTreeMkdirRequest.newBuilder().setPath(ByteString.copyFromUtf8((String)relativePath));
        try {
            this.workTreeClient.mkdir(this, requestBuilder);
        }
        catch (FileAlreadyExistsException e) {
            throw new FileAlreadyExistsException(relativePath + " could not be created");
        }
        catch (IOException e) {
            throw new IOException(relativePath + " could not be created");
        }
    }

    public void publish(@Nonnull PublishGitWorkTreeParameters parameters) {
        Objects.requireNonNull(parameters, "parameters");
        this.checkNotExpiredOrClosed();
        RpcPublishWorkTreeRequest.Builder requestBuilder = RpcPublishWorkTreeRequest.newBuilder().setBranch(ByteString.copyFromUtf8((String)parameters.getBranch()));
        if (parameters.getAuthor() != null) {
            requestBuilder.setAuthor(RpcUtils.toPerson(parameters.getAuthor()));
        }
        if (parameters.getExpectedHash() != null) {
            requestBuilder.setExpectedHash(parameters.getExpectedHash());
        }
        if (parameters.getTimeout() != null) {
            requestBuilder.setTimeouts(RpcGitTimeouts.newBuilder().setExecution(parameters.getTimeout().getSeconds()));
        }
        this.workTreeClient.publish(this, requestBuilder, parameters);
    }

    public void write(@Nonnull String relativePath, @Nonnull Charset cs, @Nonnull IoConsumer<Writer> callback) throws IOException {
        Objects.requireNonNull(relativePath, "relativePath");
        Objects.requireNonNull(cs, "cs");
        Objects.requireNonNull(callback, "callback");
        this.checkNotExpiredOrClosed();
        Path bufferFile = Files.createTempFile(this.tmpDir, Integer.toString(relativePath.hashCode()), ".tmp", new FileAttribute[0]);
        try {
            try (BufferedWriter writer = Files.newBufferedWriter(bufferFile, cs, new OpenOption[0]);){
                callback.accept((Object)writer);
            }
            RpcWriteWorkTreeFileRequest.Builder request = RpcWriteWorkTreeFileRequest.newBuilder().setPath(ByteString.copyFromUtf8((String)relativePath));
            this.workTreeClient.write(this, request, (IoSupplier<InputStream>)((IoSupplier)() -> Files.newInputStream(bufferFile, new OpenOption[0])));
        }
        catch (IOException e) {
            throw new IOException(relativePath + " could not be written");
        }
        finally {
            MoreFiles.deleteQuietly((Path)bufferFile);
        }
    }

    public void writeFrom(@Nonnull String relativePath, @Nonnull Charset cs, @Nonnull IoSupplier<Reader> contentSupplier) throws IOException {
        Objects.requireNonNull(relativePath, "relativePath");
        Objects.requireNonNull(cs, "cs");
        Objects.requireNonNull(contentSupplier, "contentSupplier");
        this.checkNotExpiredOrClosed();
        RpcWriteWorkTreeFileRequest.Builder request = RpcWriteWorkTreeFileRequest.newBuilder().setPath(ByteString.copyFromUtf8((String)relativePath));
        try {
            this.workTreeClient.write(this, request, (IoSupplier<InputStream>)((IoSupplier)() -> new ReaderInputStream(Objects.requireNonNull((Reader)contentSupplier.get(), "reader"), cs, 65536)));
        }
        catch (IOException e) {
            throw new IOException(relativePath + " could not be written");
        }
    }

    private void checkNotExpiredOrClosed() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"The work tree is closed");
        Preconditions.checkState((!this.isExpired() ? 1 : 0) != 0, (Object)"The work tree has expired");
    }
}

