/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.pull;

import com.atlassian.bitbucket.scm.git.command.merge.conflict.GitMergeConflict;
import com.atlassian.stash.internal.scm.git.pull.PullRequestMergeType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PullRequestMerge {
    private final List<GitMergeConflict> conflicts;
    private final PullRequestMergeType type;

    public PullRequestMerge(@Nonnull PullRequestMergeType type) {
        this(type, null);
    }

    public PullRequestMerge(@Nonnull PullRequestMergeType type, @Nullable List<GitMergeConflict> conflicts) {
        this.conflicts = conflicts == null ? Collections.emptyList() : conflicts;
        this.type = Objects.requireNonNull(type, "type");
    }

    @Nonnull
    public List<GitMergeConflict> getConflicts() {
        return this.conflicts;
    }

    @Nonnull
    public PullRequestMergeType getType() {
        return this.type;
    }

    public boolean hasConflicts() {
        return !this.conflicts.isEmpty();
    }
}

