/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.pull;

import com.atlassian.bitbucket.pull.PullRequestMergeOutcome;
import jakarta.annotation.Nonnull;

public enum PullRequestMergeType {
    BASE(2, "base", PullRequestMergeOutcome.UNKNOWN),
    CLEAN(0, "clean", PullRequestMergeOutcome.CLEAN),
    CONFLICTED(1, "conflicted", PullRequestMergeOutcome.CONFLICTED);

    private final int id;
    private final PullRequestMergeOutcome outcome;
    private final String type;

    private PullRequestMergeType(int id, String type, PullRequestMergeOutcome outcome) {
        this.id = id;
        this.type = type;
        this.outcome = outcome;
    }

    @Nonnull
    public static PullRequestMergeType fromId(int id) {
        for (PullRequestMergeType value : PullRequestMergeType.values()) {
            if (value.getId() != id) continue;
            return value;
        }
        throw new IllegalArgumentException("No PullRequestMergeType is associated with ID [" + id + "]");
    }

    public int getId() {
        return this.id;
    }

    @Nonnull
    public String getRefName() {
        return "merge-" + this.type;
    }

    @Nonnull
    public PullRequestMergeOutcome toOutcome() {
        return this.outcome;
    }
}

