/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.rebase;

import com.atlassian.bitbucket.hook.repository.AbstractRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookTrigger;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.bitbucket.scm.git.hook.GitRebaseHookRequest;
import com.atlassian.bitbucket.scm.git.hook.GitRepositoryHookTrigger;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;

public class SimpleGitRebaseHookRequest
extends AbstractRepositoryHookRequest
implements GitRebaseHookRequest {
    private final Branch branch;
    private final String commitId;
    private final Collection<RefChange> refChanges;
    private final String upstream;
    private final Repository upstreamRepository;

    private SimpleGitRebaseHookRequest(Builder builder) {
        super((AbstractRepositoryHookRequest.AbstractBuilder)builder);
        this.branch = Objects.requireNonNull(builder.branch, "branch");
        this.commitId = builder.commitId;
        this.upstream = Objects.requireNonNull(builder.upstream, "upstream");
        this.upstreamRepository = (Repository)MoreObjects.firstNonNull((Object)builder.upstreamRepository, (Object)this.getRepository());
        this.refChanges = this.commitId == null ? Collections.emptyList() : Collections.singletonList(((SimpleRefChange.Builder)((SimpleRefChange.Builder)((SimpleRefChange.Builder)new SimpleRefChange.Builder().from((Ref)this.branch)).toHash(this.commitId)).type(RefChangeType.UPDATE)).build());
    }

    @Nonnull
    public Branch getBranch() {
        return this.branch;
    }

    @Nonnull
    public Optional<String> getCommitId() {
        return Optional.ofNullable(this.commitId);
    }

    @Nonnull
    public Collection<RefChange> getRefChanges() {
        return this.refChanges;
    }

    @Nonnull
    public String getUpstream() {
        return this.upstream;
    }

    @Nonnull
    public Repository getUpstreamRepository() {
        return this.upstreamRepository;
    }

    public boolean isCrossRepository() {
        return this.getRepository().getId() != this.upstreamRepository.getId();
    }

    public static class Builder
    extends AbstractRepositoryHookRequest.AbstractBuilder<Builder> {
        private Branch branch;
        private String commitId;
        private String upstream;
        private Repository upstreamRepository;

        public Builder(@Nonnull Repository repository) {
            super(repository, (RepositoryHookTrigger)GitRepositoryHookTrigger.REBASE);
        }

        @Nonnull
        public Builder branch(@Nonnull Branch value) {
            this.branch = Objects.requireNonNull(value, "branch");
            return this.self();
        }

        @Nonnull
        public SimpleGitRebaseHookRequest build() {
            return new SimpleGitRebaseHookRequest(this);
        }

        @Nonnull
        public Builder commitId(@Nullable String value) {
            this.commitId = value;
            return this.self();
        }

        @Nonnull
        public Builder upstream(@Nonnull String value) {
            this.upstream = Builder.requireNonBlank((String)value, (String)"upstream");
            return this.self();
        }

        @Nonnull
        public Builder upstreamRepository(@Nullable Repository value) {
            this.upstreamRepository = value;
            return this.self();
        }

        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

