/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.ref;

import com.atlassian.bitbucket.repository.SimpleTag;
import com.atlassian.bitbucket.scm.git.ref.GitAnnotatedTag;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.user.SimplePerson;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleGitAnnotatedTag
extends SimpleTag
implements GitAnnotatedTag {
    public static final String UNSPECIFIED_NAME = "Unspecified";
    private static final Pattern TAGGER_PATTERN = Pattern.compile("(?<taggerUsername>.*) <(?<taggerEmail>.*)> (?<taggerTimestamp>\\d+) [+-]\\d+");
    private static final Logger log = LoggerFactory.getLogger(SimpleGitAnnotatedTag.class);
    private final String message;
    private final Person tagger;
    private final Instant taggerTimestamp;

    private SimpleGitAnnotatedTag(Builder builder) {
        super((SimpleTag.AbstractTagBuilder)builder);
        this.message = builder.message;
        this.tagger = Objects.requireNonNull(builder.tagger, "tagger");
        this.taggerTimestamp = builder.taggerTimestamp;
    }

    @Nonnull
    public static Person parseTagger(@Nonnull String tagger) {
        Matcher matcher = TAGGER_PATTERN.matcher(tagger);
        if (matcher.matches()) {
            String username = (String)StringUtils.defaultIfBlank((CharSequence)matcher.group("taggerUsername"), (CharSequence)UNSPECIFIED_NAME);
            String email = (String)StringUtils.defaultIfBlank((CharSequence)matcher.group("taggerEmail"), null);
            return new SimplePerson(username, email);
        }
        log.warn("Could not parse tagger from '{}'", (Object)tagger);
        return new SimplePerson(UNSPECIFIED_NAME, null);
    }

    public static Instant parseTaggerTimestamp(@Nonnull String tagger) {
        String timestamp;
        Matcher matcher = TAGGER_PATTERN.matcher(tagger);
        if (matcher.matches() && StringUtils.isNotBlank((CharSequence)(timestamp = (String)StringUtils.defaultIfBlank((CharSequence)matcher.group("taggerTimestamp"), null)))) {
            try {
                return Instant.ofEpochMilli(TimeUnit.SECONDS.toMillis(Long.parseLong(timestamp)));
            }
            catch (NumberFormatException e) {
                log.warn("Could not parse the tagger timestamp from '{}'", (Object)timestamp);
            }
        }
        log.warn("Could not parse the tagger timestamp from '{}'", (Object)tagger);
        return null;
    }

    @Nonnull
    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    @Nonnull
    public Person getTagger() {
        return this.tagger;
    }

    @Nonnull
    public Optional<Instant> getTaggerTimestamp() {
        return Optional.ofNullable(this.taggerTimestamp);
    }

    public static class Builder
    extends SimpleTag.AbstractTagBuilder<Builder, SimpleGitAnnotatedTag> {
        private String message;
        private Person tagger;
        private Instant taggerTimestamp;

        @Nonnull
        public SimpleGitAnnotatedTag build() {
            return new SimpleGitAnnotatedTag(this);
        }

        @Nonnull
        public Builder message(@Nullable String value) {
            this.message = StringUtils.isBlank((CharSequence)value) ? null : value;
            return this;
        }

        @Nonnull
        public Builder tagger(@Nonnull Person value) {
            this.tagger = Objects.requireNonNull(value, "tagger");
            return this;
        }

        @Nonnull
        public Builder taggerTimestamp(@Nullable Instant value) {
            this.taggerTimestamp = value;
            return this;
        }

        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

