/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring;

import com.atlassian.bitbucket.internal.mirroring.MirrorUpgradeRequest;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class SimpleMirrorUpgradeRequest
implements MirrorUpgradeRequest {
    private final String baseUrl;
    private final String id;
    private final String productVersion;

    private SimpleMirrorUpgradeRequest(Builder builder) {
        this.baseUrl = Objects.requireNonNull(builder.baseUrl, "baseUrl");
        this.id = Objects.requireNonNull(builder.id, "id");
        this.productVersion = Objects.requireNonNull(builder.productVersion, "productVersion");
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public String getMirrorId() {
        return this.id;
    }

    @Override
    public String getProductVersion() {
        return this.productVersion;
    }

    public static class Builder {
        private final String id;
        private String baseUrl;
        private String productVersion;

        public Builder(@Nonnull String id) {
            this.id = Objects.requireNonNull(id, "id");
        }

        @Nonnull
        public SimpleMirrorUpgradeRequest build() {
            return new SimpleMirrorUpgradeRequest(this);
        }

        @Nonnull
        public Builder baseUrl(@Nonnull String value) {
            this.baseUrl = Objects.requireNonNull(value, "baseUrl");
            return this;
        }

        @Nonnull
        public Builder productVersion(@Nonnull String version) {
            this.productVersion = Objects.requireNonNull(version, "productVersion");
            return this;
        }
    }
}

