/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring;

import com.atlassian.bitbucket.internal.mirroring.MirrorType;
import com.atlassian.bitbucket.internal.mirroring.MirroringRequest;
import com.atlassian.bitbucket.internal.mirroring.MirroringRequestState;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Objects;

public class SimpleMirroringRequest
implements MirroringRequest {
    private final Date createdDate;
    private final Integer id;
    private final String mirrorBaseUrl;
    private final String mirrorName;
    private final String mirrorId;
    private final String productVersion;
    private final MirroringRequestState state;
    private final MirrorType type;

    private SimpleMirroringRequest(Builder builder) {
        this.id = builder.id;
        this.mirrorBaseUrl = Objects.requireNonNull(builder.mirrorBaseUrl, "mirrorBaseUrl");
        this.createdDate = Objects.requireNonNull(builder.createdDate, "createdDate");
        this.mirrorName = Objects.requireNonNull(builder.mirrorName, "mirrorName");
        this.mirrorId = Objects.requireNonNull(builder.mirrorId, "mirrorId");
        this.productVersion = Objects.requireNonNull(builder.productVersion, "productVersion");
        this.state = Objects.requireNonNull(builder.state, "state");
        this.type = Objects.requireNonNull(builder.mirrorType, "mirrorType");
    }

    @Override
    @Nonnull
    public Date getCreatedDate() {
        return new Date(this.createdDate.getTime());
    }

    @Override
    @Nonnull
    public Integer getId() {
        return this.id;
    }

    @Override
    @Nonnull
    public String getBaseUrl() {
        return this.mirrorBaseUrl;
    }

    @Override
    @Nonnull
    public String getMirrorId() {
        return this.mirrorId;
    }

    @Override
    @Nonnull
    public String getMirrorName() {
        return this.mirrorName;
    }

    @Override
    @Nonnull
    public String getProductVersion() {
        return this.productVersion;
    }

    @Override
    @Nonnull
    public MirrorType getMirrorType() {
        return this.type;
    }

    @Override
    @Nullable
    public Date getResolvedDate() {
        return null;
    }

    @Override
    @Nullable
    public ApplicationUser getResolver() {
        return null;
    }

    @Override
    @Nonnull
    public MirroringRequestState getState() {
        return this.state;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("createdDate", (Object)this.createdDate).add("id", (Object)this.id).add("mirrorBaseUrl", (Object)this.mirrorBaseUrl).add("mirrorName", (Object)this.mirrorName).add("mirrorId", (Object)this.mirrorId).add("productVersion", (Object)this.productVersion).add("state", (Object)this.state).add("baseUrl", (Object)this.getBaseUrl()).add("resolvedDate", (Object)this.getResolvedDate()).add("resolver", (Object)this.getResolver()).toString();
    }

    public static class Builder {
        private Integer id;
        private Date createdDate = new Date();
        private String mirrorBaseUrl;
        private String mirrorId;
        private String mirrorName;
        private String productVersion;
        private MirroringRequestState state = MirroringRequestState.PENDING;
        private MirrorType mirrorType = MirrorType.SINGLE;

        @Nonnull
        public Builder mirrorBaseUrl(@Nonnull String value) {
            this.mirrorBaseUrl = value;
            return this;
        }

        @Nonnull
        public SimpleMirroringRequest build() {
            return new SimpleMirroringRequest(this);
        }

        @Nonnull
        public Builder createdDate(@Nonnull Date value) {
            this.createdDate = new Date(Objects.requireNonNull(value, "createdDate").getTime());
            return this;
        }

        @Nonnull
        public Builder id(@Nullable Integer id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder mirrorServer(@Nonnull String id, @Nonnull String name, @Nonnull MirrorType type) {
            this.mirrorId = Objects.requireNonNull(id, "mirrorId");
            this.mirrorName = Objects.requireNonNull(name, "mirrorName");
            this.mirrorType = Objects.requireNonNull(type, "mirrorType");
            return this;
        }

        @Nonnull
        public Builder productVersion(@Nonnull String version) {
            this.productVersion = Objects.requireNonNull(version, "productVersion");
            return this;
        }

        @Nonnull
        public Builder state(@Nonnull MirroringRequestState state) {
            this.state = Objects.requireNonNull(state, "state");
            return this;
        }
    }
}

