/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.hash;

import com.atlassian.bitbucket.dmz.mirror.hash.MirrorHash;
import com.atlassian.bitbucket.dmz.mirror.hash.MirrorHashCallback;
import com.atlassian.bitbucket.dmz.mirror.hash.MirrorHashes;
import com.atlassian.bitbucket.dmz.mirror.hash.MirrorHashesCallback;
import com.atlassian.bitbucket.internal.mirroring.hash.RepositoryHashIdMapper;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;

public class JsonHashCallback
implements MirrorHashesCallback,
MirrorHashCallback {
    private static final int NO_PROJECT = -1;
    private final RepositoryHashIdMapper idMapper;
    private final StatefulJsonWriter writer;
    private int lastProject;
    private Date lastUpdate;

    public JsonHashCallback(RepositoryHashIdMapper idMapper, StatefulJsonWriter writer) {
        this.idMapper = idMapper;
        this.writer = writer;
        this.lastProject = -1;
    }

    public void onEnd() throws IOException {
        this.maybeEndProject();
        this.writer.endArray().name("lastUpdate").value((Object)this.lastUpdate).endObject();
    }

    public boolean onHashes(@Nonnull MirrorHashes hashes) throws IOException {
        if (this.lastProject == -1) {
            this.lastUpdate = new Date();
        }
        this.maybeStartProject(hashes.getProjectId(), hashes.isPubliclyAccessible());
        this.writer.beginObject().name("id").value((long)this.idMapper.mapRepositoryId(hashes.getRepositoryId())).name("hashes").beginObject().name("content").value(hashes.getContent()).name("contentUpdatedDate").value((Object)hashes.getContentUpdatedDate()).name("metadata").value(hashes.getMetadata()).name("metadataUpdatedDate").value((Object)hashes.getMetadataUpdatedDate()).endObject().endObject();
        return true;
    }

    public boolean onHash(@Nonnull MirrorHash hash) throws IOException {
        this.maybeStartProject(hash.getProjectId(), hash.isPubliclyAccessible());
        Date updatedDate = hash.getUpdatedDate();
        String hashName = hash.getType().name().toLowerCase(Locale.ROOT);
        this.writer.beginObject().name("id").value((long)this.idMapper.mapRepositoryId(hash.getRepositoryId())).name("hashes").beginObject().name(hashName).value(hash.getHash()).name(hashName + "UpdatedDate").value((Object)updatedDate).endObject().endObject();
        if (this.lastUpdate == null || updatedDate.after(this.lastUpdate)) {
            this.lastUpdate = updatedDate;
        }
        return true;
    }

    public void onStart() throws IOException {
        this.writer.beginObject().name("projects").beginArray();
    }

    private void maybeEndProject() throws IOException {
        if (this.lastProject != -1) {
            this.writer.endArray().endObject();
        }
    }

    private void maybeStartProject(int projectId, boolean publiclyAccessible) throws IOException {
        if (projectId != this.lastProject) {
            this.maybeEndProject();
            this.writer.beginObject().name("id").value((long)this.idMapper.mapProjectId(projectId)).name("public").value(publiclyAccessible).name("repositories").beginArray();
            this.lastProject = projectId;
        }
    }
}

