/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.hash;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.hash.RepositoryHashAuthorizer;
import com.atlassian.bitbucket.internal.mirroring.upstream.InternalMirrorService;
import com.atlassian.bitbucket.mirroring.upstream.MirrorServer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class UpstreamRepositoryHashAuthorizer
implements RepositoryHashAuthorizer {
    private final AuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final InternalMirrorService mirrorService;

    @Autowired
    public UpstreamRepositoryHashAuthorizer(AuthenticationContext authenticationContext, I18nService i18nService, InternalMirrorService mirrorService) {
        this.authenticationContext = authenticationContext;
        this.i18nService = i18nService;
        this.mirrorService = mirrorService;
    }

    @Override
    public void authorize() {
        MirrorServer mirror = this.mirrorService.getForUser(this.authenticationContext.getCurrentUser());
        if (mirror == null || !mirror.isEnabled()) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.mirroring.operation.not.permitted", new Object[0]));
        }
    }
}

