/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.mirror.hash.DmzMirrorHashService;
import com.atlassian.bitbucket.dmz.mirror.hash.MirrorHashCallback;
import com.atlassian.bitbucket.dmz.mirror.hash.MirrorHashType;
import com.atlassian.bitbucket.dmz.mirror.hash.MirrorHashesCallback;
import com.atlassian.bitbucket.internal.mirroring.hash.JsonHashCallback;
import com.atlassian.bitbucket.internal.mirroring.hash.RepositoryHashAuthorizer;
import com.atlassian.bitbucket.internal.mirroring.hash.RepositoryHashIdMapperFactory;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.rest.v2.api.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Date;

@UnrestrictedAccess
@Path(value="repo-hashes")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class RepositoryHashResource {
    private final DmzMirrorHashService hashService;
    private final RepositoryHashAuthorizer repositoryHashAuthorizer;
    private final RepositoryHashIdMapperFactory repositoryHashIdMapperFactory;
    private final PermissionService permissionService;

    @Inject
    public RepositoryHashResource(DmzMirrorHashService hashService, RepositoryHashAuthorizer repositoryHashAuthorizer, RepositoryHashIdMapperFactory repositoryHashIdMapperFactory, PermissionService permissionService) {
        this.hashService = hashService;
        this.repositoryHashAuthorizer = repositoryHashAuthorizer;
        this.repositoryHashIdMapperFactory = repositoryHashIdMapperFactory;
        this.permissionService = permissionService;
    }

    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamAll() {
        this.authorize();
        return ResponseFactory.ok((Object)new JsonStreamingOutput(){

            public void write(StatefulJsonWriter writer) throws IOException {
                RepositoryHashResource.this.hashService.streamAll((MirrorHashesCallback)new JsonHashCallback(RepositoryHashResource.this.repositoryHashIdMapperFactory.create(), writer));
            }
        }).build();
    }

    @GET
    @Path(value="content")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamContentHashes(@QueryParam(value="updatedSince") Long updatedSinceMillis) {
        this.authorize();
        return this.stream(MirrorHashType.CONTENT, updatedSinceMillis);
    }

    @GET
    @Path(value="metadata")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamMetadataHashes(@QueryParam(value="updatedSince") Long updatedSinceMillis) {
        this.authorize();
        return this.stream(MirrorHashType.METADATA, updatedSinceMillis);
    }

    private void authorize() {
        if (this.permissionService.hasGlobalPermission(Permission.ADMIN)) {
            return;
        }
        this.repositoryHashAuthorizer.authorize();
    }

    private Response stream(final MirrorHashType type, Long updatedSinceMillis) {
        final Date updatedSince = updatedSinceMillis == null ? null : new Date(updatedSinceMillis);
        return ResponseFactory.ok((Object)new JsonStreamingOutput(){

            public void write(StatefulJsonWriter writer) throws IOException {
                RepositoryHashResource.this.hashService.stream(type, updatedSince, (MirrorHashCallback)new JsonHashCallback(RepositoryHashResource.this.repositoryHashIdMapperFactory.create(), writer));
            }
        }).build();
    }
}

