/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.rest;

import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;

@JsonSerialize
public class RestAnalyticsSettings
extends RestMapEntity {
    public static final String CAN_COLLECT_ANALYTICS = "canCollectAnalytics";
    public static final String SERVER_TIME = "serverTime";
    public static final String SERVICE_ENTITLEMENT_NUMBER = "serviceEntitlementNumber";

    public RestAnalyticsSettings() {
    }

    public RestAnalyticsSettings(boolean canCollectAnalytics, long serverTime, String supportEntitlementNumber) {
        this.put(CAN_COLLECT_ANALYTICS, canCollectAnalytics);
        this.put(SERVER_TIME, serverTime);
        this.put(SERVICE_ENTITLEMENT_NUMBER, Objects.requireNonNull(supportEntitlementNumber, "supportEntitlementNumber"));
    }

    @Nonnull
    public Boolean isCanCollectAnalytics() {
        return this.getBoolProperty(CAN_COLLECT_ANALYTICS);
    }

    @Schema(example="1640390400000")
    @Nonnull
    public Optional<Long> getServerTime() {
        return Optional.of(this.getLongProperty(SERVER_TIME)).filter(time -> time != -1L);
    }

    @Schema(example="SEN-500")
    @Nonnull
    public String getSupportEntitlementNumber() {
        return this.getStringProperty(SERVICE_ENTITLEMENT_NUMBER);
    }
}

