/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.rest;

import com.atlassian.bitbucket.mirroring.MirroringCapabilities;
import com.atlassian.bitbucket.mirroring.MirroringFeature;
import com.atlassian.bitbucket.mirroring.MirroringRole;
import com.atlassian.bitbucket.mirroring.RepositoryListMode;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.MoreStreams;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

@JsonSerialize
public class RestMirroringCapabilities
extends RestMapEntity {
    public static final String FEATURES = "features";
    public static final String REPOSITORY_LIST_MODES = "repository-list-modes";
    public static final String ROLES = "roles";

    public RestMirroringCapabilities() {
    }

    public RestMirroringCapabilities(MirroringCapabilities capabilities) {
        this.putIfNotEmpty(FEATURES, (Collection)capabilities.getFeatures().stream().map(MirroringFeature::getId).collect(MoreCollectors.toImmutableList()));
        this.putIfNotEmpty(ROLES, (Collection)capabilities.getRoles().stream().map(MirroringRole::getId).collect(MoreCollectors.toImmutableList()));
        this.putIfNotEmpty(REPOSITORY_LIST_MODES, (Collection)capabilities.getRepositoryListModes().stream().map(RepositoryListMode::getId).collect(MoreCollectors.toImmutableList()));
    }

    @Nonnull
    public List<MirroringFeature> getFeatures() {
        Object value = this.get(FEATURES);
        if (value instanceof Collection) {
            return (List)((Collection)value).stream().flatMap(RestMirroringCapabilities::toFeatureStream).collect(MoreCollectors.toImmutableList());
        }
        return Collections.emptyList();
    }

    @Nonnull
    public Set<RepositoryListMode> getRepositoryListModes() {
        Object value = this.get(REPOSITORY_LIST_MODES);
        if (value instanceof Collection) {
            return (Set)((Collection)value).stream().flatMap(RestMirroringCapabilities::toListModeStream).collect(MoreCollectors.toImmutableSet());
        }
        return Collections.emptySet();
    }

    @Nonnull
    public List<MirroringRole> getRoles() {
        Object value = this.get(ROLES);
        if (value instanceof Collection) {
            return (List)((Collection)value).stream().flatMap(RestMirroringCapabilities::toRoleStream).collect(MoreCollectors.toImmutableList());
        }
        return Collections.emptyList();
    }

    private static Stream<MirroringFeature> toFeatureStream(Object value) {
        if (value == null) {
            return Stream.empty();
        }
        if (value instanceof RepositoryListMode) {
            return Stream.of((MirroringFeature)((Object)value));
        }
        return MoreStreams.streamOptional(MirroringFeature.fromId(value.toString()));
    }

    private static Stream<RepositoryListMode> toListModeStream(Object value) {
        if (value == null) {
            return Stream.empty();
        }
        if (value instanceof RepositoryListMode) {
            return Stream.of((RepositoryListMode)((Object)value));
        }
        return MoreStreams.streamOptional(RepositoryListMode.fromId(value.toString()));
    }

    private static Stream<MirroringRole> toRoleStream(Object value) {
        if (value == null) {
            return Stream.empty();
        }
        if (value instanceof MirroringRole) {
            return Stream.of((MirroringRole)((Object)value));
        }
        return MoreStreams.streamOptional(MirroringRole.fromId(value.toString()));
    }
}

