/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.rest;

import com.atlassian.bitbucket.internal.mirroring.MirrorType;
import com.atlassian.bitbucket.internal.mirroring.MirroringRequest;
import com.atlassian.bitbucket.internal.mirroring.MirroringRequestState;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Optional;

@JsonSerialize
public class RestMirroringRequest
extends RestMapEntity {
    private static final String CREATED_DATE = "createdDate";
    private static final String ID = "id";
    private static final String STATE = "state";
    private static final String MIRROR_BASE_URL = "mirrorBaseUrl";
    private static final String MIRROR_ID = "mirrorId";
    private static final String MIRROR_NAME = "mirrorName";
    private static final String MIRROR_TYPE = "mirrorType";
    private static final String PRODUCT_VERSION = "productVersion";

    public RestMirroringRequest() {
    }

    public RestMirroringRequest(MirroringRequest request) {
        this.putIfNotNull(ID, request.getId());
        this.put(CREATED_DATE, request.getCreatedDate());
        this.put(MIRROR_BASE_URL, request.getBaseUrl());
        this.put(MIRROR_ID, request.getMirrorId());
        this.put(MIRROR_NAME, request.getMirrorName());
        this.put(MIRROR_TYPE, request.getMirrorType().getId());
        this.put(PRODUCT_VERSION, request.getProductVersion());
        this.put(STATE, request.getState().getId());
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public int getId() {
        return this.getIntProperty(ID);
    }

    @Schema(example="https://bitbucket-eu.example.com:7990/bitbucket")
    @RequiredString(size=450)
    public String getMirrorBaseUrl() {
        return this.getStringProperty(MIRROR_BASE_URL);
    }

    @Schema(example="Bitbucket Mirror")
    @RequiredString(size=64)
    public String getMirrorName() {
        return this.getStringProperty(MIRROR_NAME);
    }

    @Schema(example="4f0eb5fc-67fc-48f8-b4a7-87981f026c6a")
    @RequiredString(size=64)
    public String getMirrorId() {
        return this.getStringProperty(MIRROR_ID);
    }

    public Optional<MirrorType> getMirrorType() {
        return Optional.ofNullable(this.getStringProperty(MIRROR_TYPE)).map(MirrorType::fromId);
    }

    @Schema(example="8.0.0")
    @RequiredString(size=64)
    public String getProductVersion() {
        return this.getStringProperty(PRODUCT_VERSION);
    }

    public MirroringRequestState getState() {
        return MirroringRequestState.fromId(this.getStringProperty(STATE));
    }
}

