/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.rest;

import com.atlassian.bitbucket.internal.mirroring.rest.RestMirrorEventType;
import com.atlassian.bitbucket.internal.mirroring.rest.RestRepositoryMirrorEvent;
import com.atlassian.bitbucket.internal.mirroring.rest.RestServerExternalRefChange;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.rest.v2.api.repository.RestMinimalRef;
import com.atlassian.bitbucket.rest.v2.api.util.RestNamedLink;
import com.atlassian.bitbucket.scm.mirror.RepositorySynchronizationType;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.NamedLink;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonSerialize
public class RestRepositorySynchronizedEvent
extends RestRepositoryMirrorEvent {
    private static final String CLONE_LINKS = "cloneLinks";
    private static final String FAILED_REFS = "failedRefs";
    private static final String REF_CHANGES = "refChanges";
    private static final String REF_LIMIT_EXCEEDED = "refLimitExceeded";
    private static final String SYNC_TYPE = "syncType";

    public RestRepositorySynchronizedEvent() {
    }

    public RestRepositorySynchronizedEvent(@Nonnull Map<String, Object> values) {
        super(values);
    }

    public RestRepositorySynchronizedEvent(Collection<NamedLink> cloneLinks, Collection<MinimalRef> failedRefs, int mirrorRepoId, Collection<RefChange> refChanges, boolean refLimitExceeded, RepositorySynchronizationType syncType, String upstreamRepoId) {
        super(mirrorRepoId, RestMirrorEventType.SYNCHRONIZED, upstreamRepoId);
        this.put(CLONE_LINKS, cloneLinks);
        this.put(FAILED_REFS, failedRefs);
        this.put(REF_CHANGES, refChanges);
        this.put(REF_LIMIT_EXCEEDED, refLimitExceeded);
        this.put(SYNC_TYPE, syncType);
    }

    @ArraySchema(schema=@Schema(implementation=RestNamedLink.class))
    @Nonnull
    public Collection<NamedLink> getCloneLinks() {
        return this.parseAsCollection(this.get(CLONE_LINKS), RestNamedLink::valueOf);
    }

    @ArraySchema(schema=@Schema(implementation=RestMinimalRef.class))
    @Nonnull
    public Collection<MinimalRef> getFailedRefs() {
        return this.parseAsCollection(this.get(FAILED_REFS), RestMinimalRef::valueOf);
    }

    @ArraySchema(schema=@Schema(implementation=RestServerExternalRefChange.class))
    @Nonnull
    public Collection<RefChange> getRefChanges() {
        return this.parseAsCollection(this.get(REF_CHANGES), RestServerExternalRefChange::valueOf);
    }

    @Nonnull
    public RepositorySynchronizationType getSyncType() {
        return (RepositorySynchronizationType)this.getEnumProperty(SYNC_TYPE, RepositorySynchronizationType.class);
    }

    public boolean isRefLimitExceeded() {
        return this.getBoolProperty(REF_LIMIT_EXCEEDED);
    }

    private <T> Collection<T> parseAsCollection(Object value, Function<Object, T> decoder) {
        if (value instanceof Collection) {
            Collection objects = (Collection)value;
            return (Collection)objects.stream().map(decoder).filter(Objects::nonNull).collect(MoreCollectors.toImmutableList());
        }
        return Collections.emptyList();
    }
}

