/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.rest;

import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.repository.RestMinimalRef;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.Map;

public class RestServerExternalRefChange
extends RestMapEntity
implements RefChange {
    public RestServerExternalRefChange() {
    }

    private RestServerExternalRefChange(Map<String, Object> map) {
        super(map);
    }

    public RestServerExternalRefChange(RefChange refChange) {
        this.put("ref", refChange.getRef());
        this.put("fromHash", refChange.getFromHash());
        this.put("toHash", refChange.getToHash());
        this.put("type", refChange.getType());
    }

    @NotBlank
    public MinimalRef getRef() {
        return RestMinimalRef.valueOf((Object)this.get("ref"));
    }

    @NotBlank
    public String getFromHash() {
        return this.getStringProperty("fromHash");
    }

    @NotBlank
    public String getToHash() {
        return this.getStringProperty("toHash");
    }

    @NotNull
    public RefChangeType getType() {
        return (RefChangeType)this.getEnumProperty("type", RefChangeType.class, null);
    }

    public static RestServerExternalRefChange valueOf(Object value) {
        if (value instanceof RestServerExternalRefChange) {
            return (RestServerExternalRefChange)((Object)value);
        }
        if (value instanceof Map) {
            return new RestServerExternalRefChange((Map)value);
        }
        if (value instanceof RefChange) {
            return new RestServerExternalRefChange((RefChange)value);
        }
        return null;
    }
}

