/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.rest.auth;

import com.atlassian.bitbucket.internal.mirroring.auth.Credentials;
import com.atlassian.bitbucket.internal.mirroring.rest.auth.RestBearerTokenCredentials;
import com.atlassian.bitbucket.internal.mirroring.rest.auth.RestSshCredentials;
import com.atlassian.bitbucket.internal.mirroring.rest.auth.RestUsernamePasswordCredentials;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;

public class RestAuthenticationRequest
extends RestMapEntity {
    private static final String CREDENTIALS = "credentials";
    private static final String REPOSITORY_ID = "repositoryId";

    public RestAuthenticationRequest() {
    }

    public RestAuthenticationRequest(RestUsernamePasswordCredentials credentials, Integer repositoryId) {
        this.put(CREDENTIALS, credentials);
        this.putIfNotNull(REPOSITORY_ID, repositoryId);
    }

    public RestAuthenticationRequest(RestBearerTokenCredentials credentials, Integer repositoryId) {
        this.put(CREDENTIALS, credentials);
        this.putIfNotNull(REPOSITORY_ID, repositoryId);
    }

    public RestAuthenticationRequest(RestSshCredentials credentials) {
        this.put(CREDENTIALS, credentials);
    }

    @Schema(oneOf={RestUsernamePasswordCredentials.class, RestBearerTokenCredentials.class, RestSshCredentials.class})
    @NotNull(message="{bitbucket.mirroring.authentication.type.unknown}")
    public @NotNull(message="{bitbucket.mirroring.authentication.type.unknown}") Credentials getCredentials() {
        RestMapEntity credentials = RestUsernamePasswordCredentials.valueOf(this.get(CREDENTIALS));
        if (credentials == null) {
            credentials = RestSshCredentials.valueOf(this.get(CREDENTIALS));
        }
        if (credentials == null) {
            credentials = RestBearerTokenCredentials.valueOf(this.get(CREDENTIALS));
        }
        return credentials;
    }

    public Integer getRepositoryId() {
        int id = this.getIntProperty(REPOSITORY_ID);
        return id == -1 ? null : Integer.valueOf(id);
    }
}

