/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.rest.auth;

import com.atlassian.bitbucket.internal.mirroring.auth.CredentialsVisitor;
import com.atlassian.bitbucket.internal.mirroring.auth.SshCredentials;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Map;

public class RestSshCredentials
extends RestMapEntity
implements SshCredentials {
    private static final String ALGORITHM = "algorithm";
    private static final String PUBLIC_KEY = "publicKey";
    private static final String USERNAME = "username";

    public RestSshCredentials() {
    }

    public RestSshCredentials(String username, String publicKey) {
        this(username, publicKey, null);
    }

    public RestSshCredentials(String username, String publicKey, String algorithm) {
        this.put(USERNAME, username);
        this.put(PUBLIC_KEY, publicKey);
        this.putIfNotNull(ALGORITHM, algorithm);
    }

    @Override
    public <U> U accept(@Nonnull CredentialsVisitor<U> visitor) {
        return visitor.visit(this);
    }

    @Override
    @Schema(example="RSA", description="The key algorithm, if passing in a legacy X.509 encoded key. Do not specify for OpenSSH encoded keys")
    @Nullable
    public String getAlgorithm() {
        return this.getStringProperty(ALGORITHM);
    }

    @Override
    @Schema(example="git")
    @Nonnull
    public String getUsername() {
        return this.getStringProperty(USERNAME);
    }

    @Override
    @Schema(example="ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAIKjFjYCLJjrIY/jCXPbJ9wd3drcGospvPkKFNZ1ZcacA test@test.local", description="The public key text in the OpenSSH format. The algorithm must be specified in case of the legacy X.509 keys")
    @Nonnull
    public String getPublicKey() {
        return this.getStringProperty(PUBLIC_KEY);
    }

    @Nullable
    public static RestSshCredentials valueOf(@Nullable Object value) {
        if (value instanceof RestSshCredentials) {
            return (RestSshCredentials)value;
        }
        if (value instanceof Map) {
            Map values = (Map)value;
            if (values.keySet().containsAll(Arrays.asList(USERNAME, PUBLIC_KEY))) {
                String username = (String)values.get(USERNAME);
                Object publicKey = values.get(PUBLIC_KEY);
                String key = null;
                String algorithm = null;
                if (publicKey instanceof Map) {
                    Map publicKeyParts = (Map)publicKey;
                    key = (String)publicKeyParts.get("keyText");
                    algorithm = (String)publicKeyParts.get(ALGORITHM);
                }
                if (publicKey instanceof String) {
                    key = (String)publicKey;
                }
                return new RestSshCredentials(username, key, algorithm);
            }
        }
        return null;
    }
}

