/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.ssh.encoding;

import com.atlassian.bitbucket.internal.mirroring.ssh.encoding.KeyCodecException;
import com.atlassian.bitbucket.internal.mirroring.ssh.encoding.PrivateKeyPemHelper;
import jakarta.annotation.Nonnull;
import java.io.BufferedWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.PrivateKey;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public class DefaultPrivateKeyPemHelper
implements PrivateKeyPemHelper {
    @Override
    public void write(@Nonnull PrivateKey privateKey, @Nonnull Path keyFile) {
        try (BufferedWriter writer = Files.newBufferedWriter(keyFile, StandardCharsets.US_ASCII, new OpenOption[0]);
             JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);){
            pemWriter.writeObject((Object)privateKey);
        }
        catch (Exception e) {
            throw new KeyCodecException(e);
        }
    }
}

