/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.ssh.validation;

import com.atlassian.bitbucket.dmz.ssh.DmzPublicKeyCodec;
import com.atlassian.bitbucket.internal.mirroring.auth.SshCredentials;
import com.atlassian.bitbucket.internal.mirroring.ssh.validation.ValidSshCredentials;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;

public class SshCredentialValidator
implements ConstraintValidator<ValidSshCredentials, SshCredentials> {
    private final DmzPublicKeyCodec publicKeyCodec;

    public SshCredentialValidator(DmzPublicKeyCodec publicKeyCodec) {
        this.publicKeyCodec = publicKeyCodec;
    }

    public boolean isValid(SshCredentials value, ConstraintValidatorContext context) {
        try {
            if (value.getAlgorithm() == null) {
                this.publicKeyCodec.decode(value.getPublicKey());
            } else {
                this.publicKeyCodec.decodeX509Key(value.getPublicKey(), value.getAlgorithm());
            }
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }
}

