/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream;

import com.atlassian.bitbucket.internal.mirroring.upstream.InternalMirrorServer;
import com.atlassian.bitbucket.internal.mirroring.upstream.JwtGenerator;
import com.atlassian.bitbucket.internal.mirroring.upstream.MirrorLinkService;
import com.atlassian.bitbucket.internal.mirroring.upstream.nav.MirroringMirrorNavBuilder;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.httpclient.api.Request;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultMirrorLinkService
implements MirrorLinkService {
    private final JwtGenerator jwtGenerator;
    private final MirroringMirrorNavBuilder mirroringMirrorNavBuilder;

    @Autowired
    DefaultMirrorLinkService(JwtGenerator jwtGenerator, MirroringMirrorNavBuilder mirroringMirrorNavBuilder) {
        this.mirroringMirrorNavBuilder = mirroringMirrorNavBuilder;
        this.jwtGenerator = jwtGenerator;
    }

    @Override
    @Nonnull
    public String generateRepositoryAuthorizedLink(@Nonnull Repository repository, @Nonnull InternalMirrorServer mirrorServer) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(mirrorServer, "mirrorServer");
        String relativeUrl = this.mirroringMirrorNavBuilder.rest().repos(repository.getId());
        String jwt = this.jwtGenerator.generate(mirrorServer, relativeUrl, Request.Method.GET.name());
        return String.format("%s%s?jwt=%s", mirrorServer.getBaseUrl(), relativeUrl, jwt);
    }
}

