/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream;

import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.features.RequireFeature;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.MirrorUpgradeRequest;
import com.atlassian.bitbucket.internal.mirroring.MirroringRequest;
import com.atlassian.bitbucket.internal.mirroring.upstream.InternalMirrorServer;
import com.atlassian.bitbucket.internal.mirroring.upstream.InternalMirrorService;
import com.atlassian.bitbucket.internal.mirroring.upstream.MirrorServerJwtIssuer;
import com.atlassian.bitbucket.internal.mirroring.upstream.MirrorUserHelper;
import com.atlassian.bitbucket.internal.mirroring.upstream.SimpleMirrorServer;
import com.atlassian.bitbucket.internal.mirroring.upstream.SmartMirroringFeature;
import com.atlassian.bitbucket.internal.mirroring.upstream.UpstreamConstants;
import com.atlassian.bitbucket.internal.mirroring.upstream.dao.AoMirrorServer;
import com.atlassian.bitbucket.internal.mirroring.upstream.dao.MirrorServerDao;
import com.atlassian.bitbucket.internal.mirroring.upstream.mirror.MirrorLifecycleManager;
import com.atlassian.bitbucket.internal.mirroring.upstream.webhook.MirrorWebhookRegistry;
import com.atlassian.bitbucket.mirroring.upstream.MirrorAlreadyRegisteredException;
import com.atlassian.bitbucket.mirroring.upstream.MirrorEnabledEvent;
import com.atlassian.bitbucket.mirroring.upstream.MirrorInstalledEvent;
import com.atlassian.bitbucket.mirroring.upstream.MirrorServer;
import com.atlassian.bitbucket.mirroring.upstream.MirrorUninstalledEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.user.AbstractApplicationUserVisitor;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserVisitor;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jwt.JwtIssuer;
import com.atlassian.jwt.JwtIssuerRegistry;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.security.random.SecureTokenGenerator;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.java.ao.EntityStreamCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMirrorService
implements InternalMirrorService,
JwtIssuerRegistry,
LifecycleAware {
    @VisibleForTesting
    static final String PROP_ADD_ON_KEY = "plugin-key";
    @VisibleForTesting
    static final String PROP_DELETE_MIRRORS_ON_STARTUP = "plugin.mirroring.delete.on.startup";
    private static final long DEFAULT_CACHE_EXPIRY = 60L;
    private static final int DEFAULT_CACHE_MAX_SIZE = 100;
    private static final int MAX_PAGE_REQUESTS = 100;
    private static final Logger log = LoggerFactory.getLogger(DefaultMirrorService.class);
    private final MutatingApplicationLinkService applicationLinkService;
    private final ApplicationPropertiesService applicationPropertiesService;
    private final AuthenticationContext authenticationContext;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final MirrorServerDao mirrorDao;
    private final SmartMirroringFeature mirroringFeature;
    private final MirrorLifecycleManager mirrorLifecycleManager;
    private final Cache<String, InternalMirrorServer> mirrorsCache;
    private final MirrorUserHelper mirrorUserHelper;
    private final MirrorWebhookRegistry mirrorWebhookRegistry;
    private final PermissionValidationService permissionValidationService;
    private final SecureTokenGenerator secureTokenGenerator;
    private final TransactionTemplate transactionTemplate;

    public DefaultMirrorService(MutatingApplicationLinkService applicationLinkService, ApplicationPropertiesService applicationPropertiesService, AuthenticationContext authenticationContext, EventPublisher eventPublisher, I18nService i18nService, MirrorServerDao mirrorDao, SmartMirroringFeature mirroringFeature, PermissionValidationService permissionValidationService, TransactionTemplate transactionTemplate, MirrorWebhookRegistry mirrorWebhookRegistry, SecureTokenGenerator secureTokenGenerator, MirrorUserHelper mirrorUserHelper, MirrorLifecycleManager mirrorLifecycleManager, CacheFactory cacheFactory) {
        this.applicationLinkService = applicationLinkService;
        this.applicationPropertiesService = applicationPropertiesService;
        this.authenticationContext = authenticationContext;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.mirrorDao = mirrorDao;
        this.mirroringFeature = mirroringFeature;
        this.mirrorLifecycleManager = mirrorLifecycleManager;
        this.secureTokenGenerator = secureTokenGenerator;
        this.mirrorUserHelper = mirrorUserHelper;
        this.mirrorWebhookRegistry = mirrorWebhookRegistry;
        this.permissionValidationService = permissionValidationService;
        this.transactionTemplate = transactionTemplate;
        long cacheExpiry = applicationPropertiesService.getPluginProperty("plugin.mirroring.mirror-servers-cache.max", 60L);
        int cacheMaxEntries = applicationPropertiesService.getPluginProperty("plugin.mirroring.mirror-servers-cache.expiry", 100);
        this.mirrorsCache = cacheFactory.getCache(this.getClass().getName() + ".mirrors", null, new CacheSettingsBuilder().expireAfterWrite(cacheExpiry, TimeUnit.MINUTES).remote().replicateAsynchronously().replicateViaInvalidation().maxEntries(cacheMaxEntries).build());
    }

    @Override
    @Nonnull
    @RequireFeature(value=StandardFeature.SMART_MIRRORS)
    public Page<MirrorServer> findAll(@Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(pageRequest, "pageRequest");
        return (Page)this.transactionTemplate.execute(() -> PageUtils.asPageOf(MirrorServer.class, this.mirrorDao.findAll(pageRequest.buildRestrictedPageRequest(100))));
    }

    @Override
    @RequireFeature(value=StandardFeature.SMART_MIRRORS)
    public InternalMirrorServer getById(@Nonnull String mirrorId) {
        Objects.requireNonNull(mirrorId, "mirrorId");
        InternalMirrorServer mirrorServer = (InternalMirrorServer)this.mirrorsCache.get((Object)mirrorId);
        if (mirrorServer != null) {
            return mirrorServer;
        }
        return (InternalMirrorServer)this.transactionTemplate.execute(() -> {
            AoMirrorServer aoMirrorServer = this.mirrorDao.getById(mirrorId);
            if (aoMirrorServer == null) {
                return null;
            }
            SimpleMirrorServer simpleMirrorServer = new SimpleMirrorServer.Builder(aoMirrorServer).build();
            this.mirrorsCache.put((Object)mirrorId, (Object)simpleMirrorServer);
            return simpleMirrorServer;
        });
    }

    @Override
    @RequireFeature(value=StandardFeature.SMART_MIRRORS)
    public MirrorServer getForUser(@Nullable ApplicationUser user) {
        ServiceUser serviceUser;
        ServiceUser serviceUser2 = serviceUser = user == null ? null : (ServiceUser)user.accept((ApplicationUserVisitor)new AbstractApplicationUserVisitor<ServiceUser>(this){

            public ServiceUser visit(@Nonnull ServiceUser user) {
                return user;
            }
        });
        if (serviceUser == null || !serviceUser.isActive()) {
            return null;
        }
        return this.getMirrorServerFromMirrorUser(serviceUser);
    }

    @Nullable
    public JwtIssuer getIssuer(@Nonnull String issuerId) {
        Objects.requireNonNull(issuerId, "issuerId");
        if (this.mirroringFeature.isEnabled()) {
            InternalMirrorServer mirrorServer = this.getById(issuerId);
            return mirrorServer == null ? null : new MirrorServerJwtIssuer(mirrorServer);
        }
        return null;
    }

    @Override
    public boolean hasAny() {
        return this.mirrorDao.hasMirror();
    }

    @Override
    @Nonnull
    @RequireFeature(value=StandardFeature.SMART_MIRRORS)
    public MirrorServer install(@Nonnull MirroringRequest request) {
        Objects.requireNonNull(request, "request");
        this.mirroringFeature.checkEnabled();
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        AoMirrorServer created = (AoMirrorServer)this.transactionTemplate.execute(() -> {
            AoMirrorServer existing = this.mirrorDao.getById(request.getMirrorId());
            if (existing != null) {
                throw new MirrorAlreadyRegisteredException(this.i18nService.createKeyedMessage("bitbucket.mirroring.alreadyRegistered", new Object[]{request.getMirrorId()}));
            }
            AoMirrorServer installed = this.mirrorDao.create(request.getMirrorId(), request.getBaseUrl(), request.getMirrorName(), request.getMirrorType(), request.getProductVersion(), this.secureTokenGenerator.generateToken(), true);
            this.mirrorWebhookRegistry.register(installed.getBaseUrl(), installed.getId());
            this.mirrorUserHelper.upsertServiceUser(installed);
            this.eventPublisher.publish((Object)new MirrorInstalledEvent(this, installed, request.getId()));
            this.eventPublisher.publish((Object)new MirrorEnabledEvent(this, installed));
            return installed;
        });
        this.mirrorLifecycleManager.onInstalled(created);
        return created;
    }

    public void onStart() {
        if (!this.mirroringFeature.isEnabled()) {
            return;
        }
        boolean shouldForceDeleteMirrors = this.shouldForceDeleteMirrors();
        LinkedHashSet mirrorsToRemove = new LinkedHashSet();
        this.transactionTemplate.execute(() -> {
            this.mirrorDao.stream((EntityStreamCallback<AoMirrorServer, String>)((EntityStreamCallback)mirrorServer -> {
                if ((mirrorServer = this.mirrorDao.getById(mirrorServer.getId())) == null) {
                    return;
                }
                if (shouldForceDeleteMirrors) {
                    log.info("{} has been set - uninstalling mirror {}", (Object)PROP_DELETE_MIRRORS_ON_STARTUP, (Object)mirrorServer.getName());
                    this.cleanup((AoMirrorServer)mirrorServer);
                    mirrorsToRemove.add(mirrorServer);
                } else if (this.isIncompatibleMirrorVersion((MirrorServer)mirrorServer)) {
                    log.info("Removing installed mirror {} with unsupported version {}, mirror must be re-installed with version {} or higher", new Object[]{mirrorServer.getName(), mirrorServer.getProductVersion(), UpstreamConstants.MINIMUM_COMPATIBLE_MIRROR_VERSION});
                    this.cleanup((AoMirrorServer)mirrorServer);
                    mirrorsToRemove.add(mirrorServer);
                    this.mirrorUserHelper.cleanupLegacyServiceUser(mirrorServer.getId());
                    this.cleanupLegacyApplicationLinks((InternalMirrorServer)mirrorServer);
                }
            }));
            return null;
        });
        mirrorsToRemove.stream().map(MirrorServer::getId).forEach(arg_0 -> this.mirrorsCache.remove(arg_0));
        mirrorsToRemove.forEach(this.mirrorLifecycleManager::onUninstalled);
    }

    public void onStop() {
    }

    @Override
    @RequireFeature(value=StandardFeature.SMART_MIRRORS)
    public void remove(@Nonnull String mirrorId) {
        Objects.requireNonNull(mirrorId, "mirrorId");
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        AoMirrorServer deletedMirror = (AoMirrorServer)this.transactionTemplate.execute(() -> {
            AoMirrorServer mirror = this.mirrorDao.getById(mirrorId);
            if (mirror != null) {
                this.cleanup(mirror);
            }
            return mirror;
        });
        if (deletedMirror != null) {
            this.mirrorsCache.remove((Object)mirrorId);
            this.mirrorLifecycleManager.onUninstalled(deletedMirror);
        }
    }

    @Override
    @RequireFeature(value=StandardFeature.SMART_MIRRORS)
    public boolean touchLastSeen(@Nonnull String mirrorId) {
        boolean updated = (Boolean)this.transactionTemplate.execute(() -> {
            AoMirrorServer mirrorServer = this.mirrorDao.getById(mirrorId);
            if (mirrorServer == null) {
                return false;
            }
            mirrorServer.setLastSeenDate(new Date());
            mirrorServer.save();
            return true;
        });
        this.mirrorsCache.remove((Object)mirrorId);
        return updated;
    }

    @Override
    @RequireFeature(value=StandardFeature.SMART_MIRRORS)
    public MirrorServer upgrade(@Nonnull MirrorUpgradeRequest request) {
        Objects.requireNonNull(request, "request");
        AoMirrorServer updated = (AoMirrorServer)this.transactionTemplate.execute(() -> {
            AoMirrorServer mirrorServer = this.mirrorDao.getById(request.getMirrorId());
            if (mirrorServer == null) {
                return null;
            }
            ServiceUser serviceUser = this.mirrorUserHelper.getServiceUser(mirrorServer.getId());
            ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
            if (currentUser == null || serviceUser == null || serviceUser.getId() != currentUser.getId()) {
                this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
            }
            mirrorServer.setBaseUrl(request.getBaseUrl());
            mirrorServer.setProductVersion(request.getProductVersion());
            mirrorServer.setLastSeenDate(new Date());
            mirrorServer.save();
            this.mirrorWebhookRegistry.register(request.getBaseUrl(), mirrorServer.getId());
            this.mirrorUserHelper.upsertServiceUser(mirrorServer);
            return mirrorServer;
        });
        if (updated != null) {
            this.mirrorsCache.remove((Object)updated.getId());
            this.mirrorLifecycleManager.onUpgraded(updated);
        }
        return updated;
    }

    private void cleanup(AoMirrorServer mirror) {
        SimpleMirrorServer copy = new SimpleMirrorServer.Builder(mirror).enabled(false).build();
        this.mirrorDao.delete(mirror);
        this.mirrorWebhookRegistry.unregister(mirror.getId());
        this.mirrorUserHelper.cleanupServiceUser(mirror.getId());
        this.eventPublisher.publish((Object)new MirrorUninstalledEvent(this, copy));
        log.info("Mirror {} has been uninstalled", (Object)mirror.getName());
    }

    private void cleanupLegacyApplicationLinks(InternalMirrorServer mirror) {
        String addonKey = "bitbucket.mirror." + mirror.getId().toLowerCase(Locale.ROOT);
        MoreStreams.streamIterable((Iterable)this.applicationLinkService.getApplicationLinks()).filter(link -> addonKey.equals(link.getProperty(PROP_ADD_ON_KEY))).findFirst().ifPresent(arg_0 -> ((MutatingApplicationLinkService)this.applicationLinkService).deleteApplicationLink(arg_0));
    }

    private InternalMirrorServer getMirrorServerFromMirrorUser(ServiceUser serviceUser) {
        String mirrorId = MirrorUserHelper.getMirrorIdFromUsername(serviceUser.getName());
        if (mirrorId == null) {
            return null;
        }
        return this.getById(mirrorId);
    }

    private boolean isIncompatibleMirrorVersion(MirrorServer mirrorServer) {
        return new Version(mirrorServer.getProductVersion()).compareTo(UpstreamConstants.MINIMUM_COMPATIBLE_MIRROR_VERSION) < 0;
    }

    private boolean shouldForceDeleteMirrors() {
        return this.applicationPropertiesService.getPluginProperty(PROP_DELETE_MIRRORS_ON_STARTUP, false);
    }
}

