/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.internal.mirroring.MirroringRequest;
import com.atlassian.bitbucket.internal.mirroring.MirroringRequestState;
import com.atlassian.bitbucket.internal.mirroring.upstream.InternalMirrorServer;
import com.atlassian.bitbucket.internal.mirroring.upstream.InternalMirrorService;
import com.atlassian.bitbucket.internal.mirroring.upstream.MirroringRequestSearchRequest;
import com.atlassian.bitbucket.internal.mirroring.upstream.MirroringRequestService;
import com.atlassian.bitbucket.internal.mirroring.upstream.SmartMirroringFeature;
import com.atlassian.bitbucket.internal.mirroring.upstream.UpstreamConstants;
import com.atlassian.bitbucket.internal.mirroring.upstream.dao.AoMirroringRequest;
import com.atlassian.bitbucket.internal.mirroring.upstream.dao.MirroringRequestDao;
import com.atlassian.bitbucket.mirroring.upstream.ConflictingMirroringRequestException;
import com.atlassian.bitbucket.mirroring.upstream.IllegalMirroringRequestStateException;
import com.atlassian.bitbucket.mirroring.upstream.MirrorAlreadyRegisteredException;
import com.atlassian.bitbucket.mirroring.upstream.MirrorCompatibilityException;
import com.atlassian.bitbucket.mirroring.upstream.MirrorServer;
import com.atlassian.bitbucket.mirroring.upstream.MirroringRequestAcceptedEvent;
import com.atlassian.bitbucket.mirroring.upstream.MirroringRequestCreatedEvent;
import com.atlassian.bitbucket.mirroring.upstream.MirroringRequestLimitExceededException;
import com.atlassian.bitbucket.mirroring.upstream.MirroringRequestRejectedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultMirroringRequestService
implements MirroringRequestService {
    public static final int MAX_PAGE_REQUESTS = 100;
    private static final Logger log = LoggerFactory.getLogger(DefaultMirroringRequestService.class);
    private final ApplicationPropertiesService applicationPropertiesService;
    private final AuthenticationContext authenticationContext;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final MirroringRequestDao mirrorRequestDao;
    private final InternalMirrorService mirrorService;
    private final SmartMirroringFeature mirroringFeature;
    private final PermissionValidationService permissionValidationService;
    private final TransactionTemplate transactionTemplate;
    private final UserService userService;

    @Autowired
    public DefaultMirroringRequestService(ApplicationPropertiesService applicationPropertiesService, AuthenticationContext authenticationContext, EventPublisher eventPublisher, I18nService i18nService, MirroringRequestDao mirrorRequestDao, InternalMirrorService mirrorService, SmartMirroringFeature mirroringFeature, PermissionValidationService permissionValidationService, TransactionTemplate transactionTemplate, UserService userService) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.authenticationContext = authenticationContext;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.mirrorRequestDao = mirrorRequestDao;
        this.mirrorService = mirrorService;
        this.mirroringFeature = mirroringFeature;
        this.permissionValidationService = permissionValidationService;
        this.transactionTemplate = transactionTemplate;
        this.userService = userService;
    }

    @Override
    public void delete(@Nonnull MirroringRequest request) {
        this.checkEnabled();
        Objects.requireNonNull(request, "request");
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        this.aroundStateChange(request, () -> {
            this.mirrorRequestDao.delete(request.getId());
            return null;
        });
    }

    @Override
    @Nonnull
    public Page<MirroringRequest> findAll(@Nonnull PageRequest pageRequest) {
        this.checkEnabled();
        Objects.requireNonNull(pageRequest, "pageRequest");
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        return (Page)this.transactionTemplate.execute(() -> PageUtils.asPageOf(MirroringRequest.class, this.initResolvers(this.mirrorRequestDao.findAll(pageRequest.buildRestrictedPageRequest(100)))));
    }

    @Override
    @Nonnull
    public Page<MirroringRequest> findAll(@Nonnull MirroringRequestSearchRequest searchRequest, @Nonnull PageRequest pageRequest) {
        this.checkEnabled();
        Objects.requireNonNull(pageRequest, "pageRequest");
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        return (Page)this.transactionTemplate.execute(() -> PageUtils.asPageOf(MirroringRequest.class, this.initResolvers(this.mirrorRequestDao.findAll(searchRequest, pageRequest.buildRestrictedPageRequest(100)))));
    }

    @Override
    public MirroringRequest getById(int id) {
        this.checkEnabled();
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        return (MirroringRequest)this.transactionTemplate.execute(() -> this.mirrorRequestDao.getById(id));
    }

    @Override
    @Nonnull
    public MirroringRequest register(@Nonnull MirroringRequest request) {
        this.checkEnabled();
        Objects.requireNonNull(request, "request");
        return (MirroringRequest)this.aroundStateChange(request, () -> {
            this.checkMirrorVersionCompatibility(request, this.i18nService.createKeyedMessage("bitbucket.mirroring.requests.incompatibleVersion", new Object[]{request.getMirrorId(), UpstreamConstants.MINIMUM_COMPATIBLE_MIRROR_VERSION}));
            String mirrorId = request.getMirrorId();
            this.checkMirrorNotAlreadyConnected(mirrorId);
            PagedIterable existingMirroringRequests = new PagedIterable(pageRequest -> this.mirrorRequestDao.findByMirrorId(mirrorId, pageRequest), 100);
            for (AoMirroringRequest existingMirroringRequest : existingMirroringRequests) {
                if (existingMirroringRequest.getState() != MirroringRequestState.PENDING) continue;
                if (this.equivalent(existingMirroringRequest, request)) {
                    return existingMirroringRequest;
                }
                throw new ConflictingMirroringRequestException(this.i18nService.createKeyedMessage("bitbucket.mirroring.requests.pendingDiffer", new Object[]{mirrorId}));
            }
            if (this.mirrorRequestDao.countInState(MirroringRequestState.PENDING) >= this.getMaxPendingRequests()) {
                throw new MirroringRequestLimitExceededException(this.i18nService.createKeyedMessage("bitbucket.mirroring.requests.maxPendingExceeded", new Object[0]));
            }
            AoMirroringRequest newRequest = this.mirrorRequestDao.create(request);
            this.eventPublisher.publish((Object)new MirroringRequestCreatedEvent(this, newRequest));
            return newRequest;
        });
    }

    @Override
    @Nonnull
    public MirroringRequest reject(@Nonnull MirroringRequest request) {
        this.checkEnabled();
        Objects.requireNonNull(request, "request");
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        return (MirroringRequest)this.aroundStateChange(request, () -> {
            AoMirroringRequest storedRequest = this.getRequestOrFail(request);
            if (storedRequest.getState() == MirroringRequestState.REJECTED) {
                return storedRequest;
            }
            if (storedRequest.getState() == MirroringRequestState.ACCEPTED) {
                throw new IllegalMirroringRequestStateException(this.i18nService.createKeyedMessage("bitbucket.mirroring.requests.alreadyAccepted", new Object[0]));
            }
            MirroringRequest rejected = this.resolve(storedRequest, MirroringRequestState.REJECTED);
            this.eventPublisher.publish((Object)new MirroringRequestRejectedEvent(this, rejected));
            return rejected;
        });
    }

    @Override
    @Nonnull
    public MirrorServer accept(@Nonnull MirroringRequest request) {
        this.checkEnabled();
        Objects.requireNonNull(request, "request");
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        this.checkMirrorVersionCompatibility(request, this.i18nService.createKeyedMessage("bitbucket.mirroring.requests.incompatibleVersion.accept", new Object[]{request.getMirrorId(), UpstreamConstants.MINIMUM_COMPATIBLE_MIRROR_VERSION}));
        return (MirrorServer)this.aroundStateChange(request, () -> {
            AoMirroringRequest storedRequest = this.getRequestOrFail(request);
            if (storedRequest.getState() == MirroringRequestState.ACCEPTED) {
                return this.mirrorService.getById(storedRequest.getMirrorId());
            }
            this.checkMirrorNotAlreadyConnected(storedRequest.getMirrorId());
            MirrorServer mirror = this.mirrorService.install(storedRequest);
            MirroringRequest accepted = this.resolve(storedRequest, MirroringRequestState.ACCEPTED);
            this.eventPublisher.publish((Object)new MirroringRequestAcceptedEvent(this, accepted));
            return mirror;
        });
    }

    private <T> T aroundStateChange(MirroringRequest request, TransactionCallback<T> change) {
        try {
            return (T)this.transactionTemplate.execute(change);
        }
        catch (RuntimeException e) {
            if (request.getId() != null) {
                log.error("Failed to change state of mirroring request for {}", (Object)request.getBaseUrl(), (Object)e);
            } else {
                log.error("Failed to create mirroring request for {}", (Object)request.getBaseUrl(), (Object)e);
            }
            throw e;
        }
    }

    private void checkEnabled() {
        this.mirroringFeature.checkEnabled();
    }

    private void checkMirrorNotAlreadyConnected(@Nonnull String mirrorId) {
        InternalMirrorServer mirror = this.mirrorService.getById(mirrorId);
        if (mirror != null) {
            throw new MirrorAlreadyRegisteredException(this.i18nService.createKeyedMessage("bitbucket.mirroring.alreadyRegistered", new Object[]{mirrorId}));
        }
    }

    private void checkMirrorVersionCompatibility(MirroringRequest request, KeyedMessage incompatibleMessage) {
        Version mirrorVersion = new Version(request.getProductVersion());
        if (mirrorVersion.compareTo(UpstreamConstants.MINIMUM_COMPATIBLE_MIRROR_VERSION) < 0) {
            throw new MirrorCompatibilityException(incompatibleMessage);
        }
    }

    private boolean equivalent(AoMirroringRequest existingRequest, MirroringRequest request) {
        return existingRequest.getMirrorId().equals(request.getMirrorId()) && existingRequest.getMirrorName().equals(request.getMirrorName()) && existingRequest.getMirrorType().equals((Object)request.getMirrorType()) && existingRequest.getProductVersion().equals(request.getProductVersion());
    }

    private int getMaxPendingRequests() {
        return this.applicationPropertiesService.getPluginProperty("plugin.mirroring.registration.max.pending", 50);
    }

    private AoMirroringRequest getRequestOrFail(MirroringRequest request) {
        AoMirroringRequest storedRequest = this.mirrorRequestDao.getById(request.getId());
        if (storedRequest == null) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.mirroring.requests.notFound", new Object[]{request.getId()}));
        }
        return storedRequest;
    }

    private AoMirroringRequest initResolver(AoMirroringRequest request, ApplicationUser currentUser) {
        request.initResolver(currentUser);
        return request;
    }

    private Page<AoMirroringRequest> initResolvers(Page<AoMirroringRequest> requests) {
        if (requests.getSize() == 0) {
            return requests;
        }
        Set userIds = Chainable.chain((Iterable)requests.getValues()).transform(AoMirroringRequest::getResolverId).filter(Objects::nonNull).toSet();
        if (userIds.isEmpty()) {
            return requests;
        }
        ImmutableMap map = Maps.uniqueIndex((Iterable)this.userService.getUsersById(userIds), ApplicationUser::getId);
        for (AoMirroringRequest request : requests.getValues()) {
            ApplicationUser user;
            if (request.getResolverId() == null || (user = (ApplicationUser)map.get(request.getResolverId())) == null) continue;
            request.initResolver(user);
        }
        return requests;
    }

    private MirroringRequest resolve(AoMirroringRequest request, MirroringRequestState state) {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        return this.initResolver(this.mirrorRequestDao.resolve(request.getId(), state, currentUser.getId()), currentUser);
    }
}

