/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.internal.mirroring.upstream.SmartMirroringFeature;
import com.atlassian.bitbucket.mirroring.upstream.MirrorServer;
import com.atlassian.bitbucket.mirroring.upstream.MirrorService;
import com.atlassian.bitbucket.mirroring.upstream.MirroringUserSettingsService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.usersettings.UserSettings;
import com.atlassian.sal.api.usersettings.UserSettingsService;
import io.atlassian.fugue.Option;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;

public class DefaultMirroringUserSettingsService
implements MirroringUserSettingsService {
    private final AuthenticationContext authenticationContext;
    private final MirrorService mirrorService;
    private final PermissionValidationService permissionValidationService;
    private final SmartMirroringFeature mirroringFeature;
    private final UserSettingsService userSettingsService;

    DefaultMirroringUserSettingsService(AuthenticationContext authenticationContext, MirrorService mirrorService, PermissionValidationService permissionValidationService, SmartMirroringFeature mirroringFeature, UserSettingsService userSettingsService) {
        this.authenticationContext = authenticationContext;
        this.mirrorService = mirrorService;
        this.permissionValidationService = permissionValidationService;
        this.mirroringFeature = mirroringFeature;
        this.userSettingsService = userSettingsService;
    }

    @Override
    @Nonnull
    public Optional<MirrorServer> getPreferredMirror() {
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (user == null || !this.mirroringFeature.isEnabled()) {
            return Optional.empty();
        }
        UserSettings settings = this.userSettingsService.getUserSettings(UserKey.fromLong((long)user.getId()));
        Option preferredMirrorId = settings.getString("plugin.mirroring.preferred.mirror");
        if (preferredMirrorId.isEmpty()) {
            return Optional.empty();
        }
        MirrorServer mirrorServer = this.mirrorService.getById((String)preferredMirrorId.get());
        return mirrorServer == null ? Optional.empty() : Optional.of(mirrorServer);
    }

    @Override
    public void setPreferredMirror(@Nonnull MirrorServer mirror) {
        this.permissionValidationService.validateAuthenticated();
        ApplicationUser user = Objects.requireNonNull(this.authenticationContext.getCurrentUser(), "user");
        this.userSettingsService.updateUserSettings(UserKey.fromLong((long)user.getId()), input -> {
            input.put("plugin.mirroring.preferred.mirror", mirror.getId());
            return input.build();
        });
    }

    @Override
    public void removePreferredMirror() {
        this.permissionValidationService.validateAuthenticated();
        ApplicationUser user = Objects.requireNonNull(this.authenticationContext.getCurrentUser(), "user");
        this.userSettingsService.updateUserSettings(UserKey.fromLong((long)user.getId()), input -> {
            input.remove("plugin.mirroring.preferred.mirror");
            return input.build();
        });
    }
}

