/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.upstream.SmartMirroringFeature;
import com.atlassian.bitbucket.mirroring.upstream.MirroringDisabledException;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.IncompatibleApplicationModeException;
import com.atlassian.bitbucket.server.StandardFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultSmartMirroringFeature
implements SmartMirroringFeature {
    private static final Logger log = LoggerFactory.getLogger(DefaultSmartMirroringFeature.class);
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final ApplicationPropertiesService propertiesService;

    @Autowired
    public DefaultSmartMirroringFeature(FeatureManager featureManager, I18nService i18nService, ApplicationPropertiesService propertiesService) {
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.propertiesService = propertiesService;
    }

    @Override
    public void checkEnabled() {
        ApplicationMode mode = this.propertiesService.getMode();
        if (mode != ApplicationMode.DEFAULT) {
            throw new IncompatibleApplicationModeException(this.i18nService.createKeyedMessage("bitbucket.mirroring.incompatibleApplicationMode", new Object[]{mode}));
        }
        if (!this.isEnabled()) {
            log.debug("The mirroring feature is not enabled.");
            throw new MirroringDisabledException(this.i18nService.createKeyedMessage("bitbucket.mirroring.feature.disabled", new Object[0]));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.featureManager.isEnabled((Feature)StandardFeature.SMART_MIRRORS);
    }
}

