/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream;

import com.atlassian.bitbucket.internal.mirroring.jwt.JwtTokenHelper;
import com.atlassian.bitbucket.internal.mirroring.upstream.InternalMirrorServer;
import com.atlassian.jwt.httpclient.CanonicalHttpUriRequest;
import com.atlassian.oauth.consumer.ConsumerService;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JwtGenerator {
    private static final long JWT_EXPIRY = TimeUnit.SECONDS.toSeconds(60L);
    private final ConsumerService consumerService;
    private final JwtTokenHelper jwtTokenHelper;

    @Autowired
    public JwtGenerator(ConsumerService consumerService, JwtTokenHelper jwtTokenHelper) {
        this.consumerService = consumerService;
        this.jwtTokenHelper = jwtTokenHelper;
    }

    @Nonnull
    public String generate(@Nonnull InternalMirrorServer mirror, @Nonnull String relativeUrl, @Nonnull String methodName) {
        Objects.requireNonNull(mirror, "mirrorServer");
        Objects.requireNonNull(relativeUrl, "relativeUrl");
        Objects.requireNonNull(methodName, "methodName");
        return this.generateJwt(relativeUrl, methodName, mirror.getSharedSecret());
    }

    private String generateJwt(String relativeUrl, String methodName, String sharedSecret) {
        return this.jwtTokenHelper.generateToken(new CanonicalHttpUriRequest(methodName, relativeUrl, ""), JWT_EXPIRY, this.consumerService.getConsumer().getKey(), null, sharedSecret);
    }
}

