/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream;

import com.atlassian.bitbucket.mirroring.upstream.MirrorLifecycleEvent;
import com.atlassian.bitbucket.mirroring.upstream.MirrorService;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.sal.api.web.context.HttpContext;
import com.atlassian.security.csp.api.CspDirective;
import com.atlassian.security.csp.api.CspFragment;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component(value="mirrorCspFragment")
public class MirrorCspFragment
implements CspFragment {
    private static final Set<CspDirective> CSP_DIRECTIVES = Set.of(CspDirective.CONNECT_SRC);
    private static final Object LOCK = new Object();
    private final HttpContext httpContext;
    private final MirrorService mirrorService;
    private volatile Set<URI> mirrorOrigins;

    public MirrorCspFragment(HttpContext httpContext, MirrorService mirrorService) {
        this.httpContext = httpContext;
        this.mirrorService = mirrorService;
    }

    public Set<CspDirective> getCSPDirectives() {
        return CSP_DIRECTIVES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<URI> getCSPOrigins(CspDirective directive) {
        if (this.mirrorOrigins == null) {
            Object object = LOCK;
            synchronized (object) {
                if (this.mirrorOrigins == null) {
                    this.reloadMirrorOrigins();
                }
            }
        }
        return this.mirrorOrigins;
    }

    public Set<String> getUrlPatterns() {
        HttpServletRequest request = this.httpContext.getRequest();
        String contextPath = request != null ? request.getContextPath() : "/**";
        return Set.of(contextPath + "/plugins/servlet/admin/mirrors/**");
    }

    @EventListener
    public void onMirroringLifecycleEvent(MirrorLifecycleEvent event) {
        this.reloadMirrorOrigins();
    }

    private void reloadMirrorOrigins() {
        this.mirrorOrigins = this.mirrorService.findAll(PageUtils.newRequest((int)0, (int)0x100000)).stream().map(m -> URI.create(m.getBaseUrl() + "/")).collect(Collectors.toSet());
    }
}

