/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream;

import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.bitbucket.audit.AuditEventConverter;
import com.atlassian.bitbucket.mirroring.upstream.MirrorLifecycleEvent;
import com.atlassian.bitbucket.mirroring.upstream.MirrorServer;
import jakarta.annotation.Nonnull;

public class MirrorLifecycleEventConverter
implements AuditEventConverter<MirrorLifecycleEvent> {
    @Nonnull
    public AuditEvent convert(@Nonnull MirrorLifecycleEvent event, @Nonnull AuditEvent.Builder builder) {
        MirrorServer mirror = event.getMirror();
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)"bitbucket.mirroring.audit.attribute.mirrorevent.mirrorid", (String)mirror.getId()).build());
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)"bitbucket.mirroring.audit.attribute.mirrorevent.baseurl", (String)mirror.getBaseUrl()).build());
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)"bitbucket.mirroring.audit.attribute.mirrorevent.type", (String)mirror.getMirrorType().name()).build());
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)"bitbucket.mirroring.audit.attribute.mirrorevent.version", (String)mirror.getProductVersion()).build());
        builder.affectedObject(AuditResource.builder((String)mirror.getName(), (String)"MIRROR").build());
        return builder.build();
    }
}

