/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream;

import com.atlassian.bitbucket.event.user.UserCleanupEvent;
import com.atlassian.bitbucket.mirroring.upstream.MirrorServer;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.user.ServiceUserCreateRequest;
import com.atlassian.bitbucket.user.ServiceUserUpdateRequest;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.event.api.EventPublisher;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MirrorUserHelper {
    public static final String MIRROR_SERVICE_USER_LABEL = "bitbucket-mirror";
    private static final Logger log = LoggerFactory.getLogger(MirrorUserHelper.class);
    private static final String PREFIX_LEGACY_MIRROR_SERVICE_USER = "addon_bitbucket.mirror.";
    private static final String PREFIX_MIRROR_SERVICE_USER = "bitbucket.mirror.";
    private final EventPublisher eventPublisher;
    private final UserAdminService userAdminService;
    private final UserService userService;

    @Autowired
    public MirrorUserHelper(EventPublisher eventPublisher, UserAdminService userAdminService, UserService userService) {
        this.eventPublisher = eventPublisher;
        this.userAdminService = userAdminService;
        this.userService = userService;
    }

    @Nullable
    public static String getMirrorIdFromUsername(@Nonnull String username) {
        if (MirrorUserHelper.isMirrorServiceUsername(username)) {
            return username.substring(PREFIX_MIRROR_SERVICE_USER.length());
        }
        return null;
    }

    @Nonnull
    public static String getUsernameFor(@Nonnull String mirrorId) {
        return PREFIX_MIRROR_SERVICE_USER + Objects.requireNonNull(mirrorId, "mirrorId");
    }

    public static boolean isMirrorServiceUser(ApplicationUser user) {
        return user != null && user.getType() == UserType.SERVICE && MirrorUserHelper.isMirrorServiceUsername(user.getName());
    }

    public static boolean isMirrorServiceUsername(@Nonnull String username) {
        return Objects.requireNonNull(username, "username").startsWith(PREFIX_MIRROR_SERVICE_USER);
    }

    public void cleanupLegacyServiceUser(@Nonnull String mirrorId) {
        Objects.requireNonNull(mirrorId, "mirrorId");
        this.cleanupServiceUser(this.userService.getServiceUserByName(PREFIX_LEGACY_MIRROR_SERVICE_USER + mirrorId.toLowerCase(Locale.ROOT), true));
    }

    public void cleanupServiceUser(@Nonnull String mirrorId) {
        Objects.requireNonNull(mirrorId, "mirrorId");
        this.cleanupServiceUser(this.getServiceUser(mirrorId));
    }

    @Nullable
    public ServiceUser getServiceUser(@Nonnull String mirrorId) {
        return this.userService.getServiceUserByName(MirrorUserHelper.getUsernameFor(mirrorId), true);
    }

    public void upsertServiceUser(@Nonnull MirrorServer mirrorServer) {
        Objects.requireNonNull(mirrorServer, "mirrorServer");
        ServiceUser user = this.getServiceUser(mirrorServer.getId());
        if (user == null) {
            this.userAdminService.createServiceUser(((ServiceUserCreateRequest.Builder)((ServiceUserCreateRequest.Builder)((ServiceUserCreateRequest.Builder)((ServiceUserCreateRequest.Builder)new ServiceUserCreateRequest.Builder().label(MIRROR_SERVICE_USER_LABEL)).name(MirrorUserHelper.getUsernameFor(mirrorServer.getId()))).active(true)).displayName(mirrorServer.getName())).build());
            log.debug("Created service user for the mirror with ID {}", (Object)mirrorServer.getId());
        } else {
            this.userAdminService.updateServiceUser(((ServiceUserUpdateRequest.Builder)((ServiceUserUpdateRequest.Builder)new ServiceUserUpdateRequest.Builder(user).displayName(mirrorServer.getName())).active(true)).build());
            log.debug("Updated service user for the mirror with ID {}", (Object)mirrorServer.getId());
        }
    }

    private void cleanupServiceUser(ServiceUser user) {
        if (user != null) {
            if (user.isActive()) {
                this.userAdminService.updateServiceUser(((ServiceUserUpdateRequest.Builder)new ServiceUserUpdateRequest.Builder(user).active(false)).build());
            }
            this.eventPublisher.publish((Object)new UserCleanupEvent((Object)this, (ApplicationUser)user));
        }
    }
}

