/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.upstream;

import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.bitbucket.audit.AuditEventConverter;
import com.atlassian.bitbucket.internal.mirroring.MirroringRequest;
import com.atlassian.bitbucket.mirroring.upstream.MirroringRequestEvent;
import jakarta.annotation.Nonnull;

public class MirroringRequestEventConverter
implements AuditEventConverter<MirroringRequestEvent> {
    @Nonnull
    public AuditEvent convert(@Nonnull MirroringRequestEvent event, @Nonnull AuditEvent.Builder builder) {
        MirroringRequest request = event.getRequest();
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)"bitbucket.mirroring.audit.attribute.mirrorevent.mirrorid", (String)request.getMirrorId()).build());
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)"bitbucket.mirroring.audit.attribute.mirrorevent.baseurl", (String)request.getBaseUrl()).build());
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)"bitbucket.mirroring.audit.attribute.mirrorevent.type", (String)request.getMirrorType().name()).build());
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)"bitbucket.mirroring.audit.attribute.mirrorevent.version", (String)request.getProductVersion()).build());
        builder.affectedObject(AuditResource.builder((String)request.getMirrorName(), (String)"MIRROR").build());
        return builder.build();
    }
}

